<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Event Management</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="{{ asset('front/css/bootstrap.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('assets/css/vcard14.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick-theme.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vacrd/slick-theme.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/custom.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/custom-vcard.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/third-party.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/plugins.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/lightbox.css') }}">
</head>

<body>
    <div class="container p-0">
        <div class="main-content mx-auto w-100 overflow-hidden">
            <div class="banner-section position-relative">
                <div class="banner-img">
                    <img src="{{ asset('assets/img/vcard14/banner-img.png') }}" class="w-100 h-100 object-fit-cover" />
                    <div class="d-flex justify-content-end position-absolute top-0 end-0 me-3">
                        <div class="language pt-3 me-2">
                            <ul class="text-decoration-none">
                                <li class="dropdown1 dropdown lang-list">
                                    <a class="dropdown-toggle lang-head text-decoration-none" data-toggle="dropdown"
                                        role="button" aria-haspopup="true" aria-expanded="false">
                                        <i class="fa-solid fa-language me-2"></i>Language</a>
                                    <ul class="dropdown-menu start-0 lang-hover-list top-100 mt-0">
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/english.png') }}" width="25px"
                                                height="20px" class="me-3"><a href="#">English</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/spain.png') }}" width="25px"
                                                height="20px" class="me-3"><a href="#">Spanish</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/france.png') }}" width="25px"
                                                height="20px" class="me-3"><a href="#">Franch</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/arabic.svg') }}" width="25px"
                                                height="20px" class="me-3"><a href="#">Arabic</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/german.png') }}" width="25px"
                                                height="20px" class="me-3"><a href="#">German</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/russian.jpeg') }}" width="25px"
                                                height="20px" class="me-3"><a href="#">russian</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/turkish.png') }}" width="25px"
                                                height="20px" class="me-3"><a href="#">Turkish</a>
                                        </li>

                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="overlay"></div>
                </div>
            </div>
            <div class="profile-section px-30">
                <div class="card flex-sm-row align-items-center mb-40">
                    <div class="card-img me-sm-3">
                        <img src="{{ asset('assets/img/vcard14/profile-img.png') }}" class="img-fluid" />
                    </div>
                    <div class="card-body text-sm-start text-center">
                        <div class="profile-name">
                            <h2 class="text-white mb-0 fs-36">Vanessa Joe</h2>
                            <p class="fs-18 text-gradient mb-0">Event Manager</p>
                        </div>
                    </div>
                </div>
                <p class="text-gray-100 mb-0 text-center">
                    Lorem Ipsum is simply dummy text of the printing and typesetting
                    industry. Lorem Ipsum has been the industry's standard dummy text
                    ever since the 1500s, when an unknown printer took a galley of type
                    and scrambled it.
                </p>
            </div>
            <div class="social-media d-flex justify-content-end">
                <div class="flex-1 social-media-bg"></div>
                <div class="social-media-icon flex-1 d-flex">
                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="13" height="25" viewBox="0 0 13 25" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M3.73824 14.1111C3.18372 14.1111 2.67459 14.1111 2.16547 14.1111C1.73123 14.1111 1.297 14.1193 0.863524 14.1079C0.409622 14.0964 0.261348 13.9495 0.257565 13.4638C0.24773 12.1912 0.246974 10.9179 0.258322 9.64528C0.262861 9.16368 0.421726 9.01103 0.869577 9.00777C1.7093 9.00205 2.54901 9.00613 3.38949 9.00613C3.49237 9.00613 3.59526 9.00613 3.73824 9.00613C3.73824 8.86818 3.73673 8.74982 3.73824 8.63228C3.75791 7.47235 3.71706 6.30752 3.80935 5.15412C4.04311 2.21633 6.12123 0.1185 8.85372 0.0229951C9.96578 -0.0161863 11.0809 0.00585325 12.1937 0.00911836C12.5856 0.00993464 12.7444 0.182986 12.7459 0.60745C12.7512 1.7984 12.7512 2.99016 12.7467 4.18111C12.7452 4.63741 12.5969 4.80312 12.1619 4.81373C11.3978 4.83332 10.6338 4.83332 9.86895 4.84638C9.01183 4.86026 8.65173 5.22187 8.63357 6.13528C8.61542 7.05849 8.62979 7.98334 8.62979 8.94246C8.75915 8.94246 8.85977 8.94246 8.96038 8.94246C9.93249 8.94246 10.9046 8.94083 11.8767 8.94328C12.4895 8.9441 12.6332 9.09756 12.634 9.74731C12.6347 10.9587 12.6362 12.1708 12.6332 13.3822C12.6317 13.9242 12.4993 14.0703 11.994 14.0728C10.8902 14.0777 9.78649 14.0744 8.63055 14.0744C8.63055 14.2164 8.63055 14.343 8.63055 14.4687C8.63055 17.6554 8.63055 20.843 8.63055 24.0297C8.63055 24.908 8.54431 24.9995 7.71669 24.9995C6.63111 24.9995 5.54628 25.0011 4.4607 24.9986C3.8797 24.9978 3.73824 24.8468 3.73824 24.2264C3.73748 20.9883 3.73748 17.7501 3.73748 14.5127C3.73824 14.3927 3.73824 14.2728 3.73824 14.1111Z"
                                fill="url(#paint0_linear_401_60)" />
                            <defs>
                                <linearGradient id="paint0_linear_401_60" x1="0.25" y1="0"
                                    x2="19.9537" y2="8.71721" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A932" />
                                    <stop offset="1" stop-color="#FF5A0E" />
                                </linearGradient>
                            </defs>
                        </svg>
                    </a>
                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M25 11.2256C25 11.7143 25 12.2024 25 12.6912C24.9608 13.0129 24.9289 13.3352 24.8818 13.6557C24.5001 16.2479 23.401 18.4908 21.5606 20.3588C19.5879 22.3613 17.1968 23.5418 14.4032 23.8654C11.9606 24.1486 9.63499 23.7204 7.44909 22.5821C7.29838 22.5039 7.17034 22.4733 6.99451 22.5363C5.70062 22.9999 4.40059 23.4458 3.10363 23.9015C2.06827 24.2648 1.03475 24.6336 0 25C0.0214424 24.8979 0.0312446 24.792 0.0655525 24.6942C0.831352 22.5008 1.59593 20.3062 2.37398 18.1171C2.46526 17.8608 2.45852 17.662 2.33109 17.4137C1.15666 15.1286 0.770088 12.7022 1.14686 10.1693C1.52547 7.62363 2.62516 5.4119 4.44715 3.58796C7.14951 0.883244 10.4339 -0.285619 14.2347 0.0587402C16.545 0.267925 18.6224 1.12056 20.4358 2.57323C22.7976 4.46446 24.2746 6.89393 24.8101 9.87878C24.8897 10.3247 24.9375 10.7767 25 11.2256ZM10.2899 9.86716C10.3052 9.84025 10.3077 9.83169 10.3132 9.82618C10.6287 9.50812 10.946 9.19251 11.2591 8.87262C11.6267 8.49645 11.6267 8.09215 11.2554 7.71721C10.7224 7.17957 10.187 6.64377 9.64785 6.11163C9.26802 5.73669 8.86796 5.73669 8.48935 6.10918C8.09481 6.49758 7.71498 6.90127 7.31063 7.27927C6.85299 7.70743 6.71698 8.23161 6.77886 8.8298C6.8824 9.82435 7.29287 10.7082 7.80013 11.5468C9.11915 13.7267 10.8688 15.4986 12.9929 16.9005C13.8518 17.4675 14.764 17.9324 15.7871 18.1391C16.5737 18.2981 17.2673 18.185 17.826 17.5391C18.1446 17.1709 18.514 16.8461 18.8583 16.4993C19.2528 16.1011 19.2522 15.7072 18.8546 15.3066C18.3498 14.7983 17.8413 14.2931 17.334 13.7872C16.8684 13.323 16.5008 13.3218 16.0377 13.7836C15.7338 14.0869 15.4312 14.3915 15.131 14.6925C12.9506 13.6251 11.3485 12.0251 10.2899 9.86716Z"
                                fill="url(#paint0_linear_401_3)" />
                            <defs>
                                <linearGradient id="paint0_linear_401_3" x1="0" y1="0"
                                    x2="26.4289" y2="23.3851" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A932" />
                                    <stop offset="1" stop-color="#FF5A0E" />
                                </linearGradient>
                            </defs>
                        </svg>
                    </a>
                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M24.9829 15.1366C24.9747 13.9763 24.859 12.8226 24.5217 11.7014C24.0996 10.2974 23.3345 9.1681 21.9696 8.52396C20.9152 8.02659 19.7908 7.88716 18.6418 7.9214C16.6308 7.98174 15.0036 8.75797 13.9158 10.5126C13.9036 10.5322 13.871 10.5395 13.8025 10.5787C13.8025 9.80816 13.8025 9.07188 13.8025 8.33479C12.1297 8.33479 10.4975 8.33479 8.86951 8.33479C8.86951 13.9037 8.86951 19.4507 8.86951 25C10.5929 25 12.2886 25 14.0282 25C14.0282 24.8475 14.0282 24.7269 14.0282 24.6054C14.0282 22.0011 14.0209 19.396 14.0339 16.7918C14.0364 16.2137 14.0739 15.6315 14.1562 15.0599C14.3811 13.4928 15.178 12.6456 16.6251 12.4744C18.2149 12.2869 19.3247 12.8666 19.6392 14.5731C19.7508 15.1798 19.7997 15.8052 19.8038 16.4224C19.8217 19.149 19.8136 21.8755 19.8144 24.6021C19.8144 24.7195 19.8144 24.8361 19.8144 24.9478C21.5663 24.9478 23.2693 24.9478 24.9878 24.9478C24.9927 24.8793 25 24.8304 25 24.7807C24.9959 21.5665 25.0041 18.3515 24.9829 15.1366Z"
                                fill="url(#paint0_linear_401_122)" />
                            <path
                                d="M0.429688 24.9886C2.15633 24.9886 3.86667 24.9886 5.58271 24.9886C5.58271 19.427 5.58271 13.8882 5.58271 8.33069C3.86259 8.33069 2.15959 8.33069 0.429688 8.33069C0.429687 13.8988 0.429688 19.4384 0.429688 24.9886Z"
                                fill="url(#paint1_linear_401_122)" />
                            <path
                                d="M2.98067 0.000119092C1.34204 0.0147956 -0.000814466 1.3683 3.70634e-07 3.00392C0.000815207 4.66726 1.37381 6.0436 3.02223 6.03381C4.66168 6.02403 6.00616 4.65014 5.99638 2.99251C5.98742 1.32916 4.63316 -0.0145575 2.98067 0.000119092Z"
                                fill="url(#paint2_linear_401_122)" />
                            <defs>
                                <linearGradient id="paint0_linear_401_122" x1="8.86951" y1="7.9165"
                                    x2="26.7748" y2="22.8758" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A932" />
                                    <stop offset="1" stop-color="#FF5A0E" />
                                </linearGradient>
                                <linearGradient id="paint1_linear_401_122" x1="0.429688" y1="8.33069"
                                    x2="9.4653" y2="10.8039" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A932" />
                                    <stop offset="1" stop-color="#FF5A0E" />
                                </linearGradient>
                                <linearGradient id="paint2_linear_401_122" x1="0" y1="0"
                                    x2="6.37379" y2="5.60472" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A932" />
                                    <stop offset="1" stop-color="#FF5A0E" />
                                </linearGradient>
                            </defs>
                        </svg>
                    </a>

                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M24.9972 5.76124C24.9972 10.253 24.9972 14.744 24.9972 19.2357C24.8986 19.7027 24.8405 20.1834 24.6945 20.6351C23.8431 23.262 21.4807 24.9855 18.7086 24.9931C14.5676 25.0046 10.4267 24.9993 6.28576 24.9947C4.95589 24.9931 3.72997 24.6255 2.65308 23.8383C0.873808 22.5375 0.000985528 20.7681 0.000985528 18.5662C0.000221236 14.5391 -0.00207164 10.5121 0.00480699 6.48502C0.00557128 6.07231 0.0246786 5.65194 0.098815 5.24687C0.518412 2.93718 1.8307 1.32605 3.99824 0.444054C4.55388 0.217823 5.17219 0.143687 5.76146 0C10.2532 0 14.7442 0 19.2359 0C19.411 0.031336 19.5867 0.0603791 19.761 0.0932437C22.0554 0.526598 23.662 1.8259 24.5455 3.97738C24.7771 4.53913 24.8512 5.16509 24.9972 5.76124ZM22.8992 12.4985C22.9022 12.4985 22.9053 12.4985 22.9084 12.4985C22.9084 10.4647 22.9045 8.43091 22.9107 6.39637C22.9122 5.74442 22.8251 5.11159 22.5339 4.52538C21.7451 2.93641 20.4588 2.09645 18.6803 2.09034C14.5554 2.07582 10.4305 2.08499 6.30563 2.08805C6.06259 2.08805 5.81802 2.11098 5.57803 2.14537C3.68488 2.41211 2.11731 4.12412 2.10508 6.04097C2.0768 10.2958 2.09362 14.5506 2.09133 18.8054C2.09133 19.3832 2.20444 19.9412 2.45895 20.4578C3.2584 22.0774 4.56916 22.9043 6.37824 22.9066C10.4542 22.9127 14.5302 22.9097 18.6062 22.9059C18.8813 22.9059 19.1587 22.8845 19.4316 22.847C21.2881 22.5925 22.8671 20.8614 22.8923 18.9896C22.9221 16.8267 22.8992 14.663 22.8992 12.4985Z"
                                fill="url(#paint0_linear_401_106)" />
                            <path
                                d="M18.7468 12.5291C18.7139 15.9898 15.8792 18.7909 12.4552 18.7458C8.99826 18.7007 6.21776 15.8874 6.25062 12.4664C6.28349 9.00416 9.11596 6.20608 12.5415 6.24965C15.9992 6.29474 18.7797 9.1081 18.7468 12.5291ZM12.5025 8.33769C10.2035 8.33387 8.34784 10.1835 8.33867 12.4886C8.32874 14.7845 10.1768 16.644 12.4834 16.6593C14.7862 16.6738 16.6618 14.8044 16.6595 12.4962C16.6572 10.1942 14.8046 8.34152 12.5025 8.33769Z"
                                fill="url(#paint1_linear_401_106)" />
                            <path
                                d="M19.281 7.2822C18.4112 7.28831 17.7142 6.59663 17.7142 5.72763C17.715 4.87238 18.399 4.1807 19.2573 4.16694C20.1049 4.15318 20.8325 4.87468 20.8318 5.72839C20.8318 6.57905 20.1355 7.27608 19.281 7.2822Z"
                                fill="url(#paint2_linear_401_106)" />
                            <defs>
                                <linearGradient id="paint0_linear_401_106" x1="0" y1="0"
                                    x2="26.4286" y2="23.3821" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A932" />
                                    <stop offset="1" stop-color="#FF5A0E" />
                                </linearGradient>
                                <linearGradient id="paint1_linear_401_106" x1="6.25034" y1="6.24915"
                                    x2="19.4618" y2="17.9386" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A932" />
                                    <stop offset="1" stop-color="#FF5A0E" />
                                </linearGradient>
                                <linearGradient id="paint2_linear_401_106" x1="17.7142" y1="4.16675"
                                    x2="21.008" y2="7.08315" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A932" />
                                    <stop offset="1" stop-color="#FF5A0E" />
                                </linearGradient>
                            </defs>
                        </svg>
                    </a>

                    <a href="" class="social-icon d-flex justify-content-center align-items-center">
                        <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_12_65)">
                                <path
                                    d="M7.38945 18.6214C5.04288 18.3168 3.48602 17.2112 2.60606 15C3.36192 15 4.02754 15 4.68187 15C2.30145 14.0637 0.958945 12.4278 0.789721 9.83307C1.51174 10.0361 2.17736 10.2279 2.84297 10.4084C2.87681 10.3633 2.91066 10.3182 2.9445 10.2731C1.95172 9.47206 1.24098 8.47928 0.99279 7.21574C0.744595 5.9522 0.85741 4.73379 1.54559 3.48153C4.38855 6.71935 7.86328 8.60338 12.139 8.87413C12.139 8.40031 12.1277 7.99417 12.139 7.58803C12.2067 5.43325 13.2672 3.86511 15.1963 2.99643C17.0803 2.15031 18.9305 2.37594 20.5551 3.70717C21.0063 4.07946 21.4125 4.15843 21.9201 3.95536C22.6986 3.65076 23.477 3.34616 24.3231 3.03027C23.9621 4.15843 23.2175 4.92558 22.4391 5.76042C23.2514 5.54607 24.0636 5.32043 24.8759 5.10608C24.9098 5.13993 24.9549 5.17377 24.9887 5.20762C24.3457 5.87323 23.7365 6.59525 23.037 7.19318C22.6534 7.52034 22.5068 7.84751 22.4955 8.33262C22.4278 11.7284 21.4125 14.8082 19.3141 17.4933C16.4937 21.1147 12.7482 22.9423 8.13403 23.0325C5.49414 23.0889 3.02348 22.5361 0.699468 21.2839C0.473837 21.1598 0.248205 21.0244 0.0112915 20.8326C2.68503 20.9567 5.12185 20.3249 7.38945 18.6214Z"
                                    fill="url(#paint0_linear_12_65)" />
                            </g>
                            <defs>
                                <linearGradient id="paint0_linear_12_65" x1="0.0112915" y1="2.4975"
                                    x2="21.8283" y2="25.9735" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A932" />
                                    <stop offset="1" stop-color="#FF5A0E" />
                                </linearGradient>
                                <clipPath id="clip0_12_65">
                                    <rect width="25" height="20.5325" fill="white"
                                        transform="translate(0 2.5)" />
                                </clipPath>
                            </defs>
                        </svg>
                    </a>
                </div>
            </div>
            <div class="contact-section pt-60 pb-60">
                <div class="section-heading">
                    <h2 class="text-white mb-0">Contact</h2>
                </div>
                <div class="px-30 pt-3 mt-3">
                    <div class="row">
                        <div class="col-sm-6 mb-40">
                            <div class="contact-box d-flex align-items-center">
                                <div class="contact-icon d-flex justify-content-center align-items-center">
                                    <svg width="26" height="20" viewBox="0 0 26 20" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_12_171)">
                                            <path
                                                d="M13.0249 -0.000469008C16.3357 -0.000469008 19.6398 -0.0071379 22.9506 0.00619988C23.3836 0.00619988 23.8233 0.0528821 24.243 0.146247C24.9957 0.319638 25.5153 0.799798 25.8417 1.49336C26.1282 2.10023 26.0349 2.43368 25.4753 2.78713C24.7492 3.24728 24.0165 3.70076 23.2904 4.16092C20.1195 6.18159 16.9486 8.18893 13.791 10.2229C13.2181 10.5964 12.7651 10.5831 12.1922 10.2163C8.34851 7.74211 4.48482 5.3013 0.627786 2.84715C0.547848 2.7938 0.461248 2.74711 0.387971 2.69376C0.00826269 2.43368 -0.0650143 2.22694 0.0682165 1.79346C0.394632 0.72644 1.20734 0.106233 2.39976 0.0395443C2.87939 0.0128688 3.35902 0.0128688 3.83199 0.00619988C6.8963 0.00619988 9.96061 0.00619988 13.0249 -0.000469008C13.0249 0.00619988 13.0249 -0.000469008 13.0249 -0.000469008Z"
                                                fill="white" />
                                            <path
                                                d="M12.9701 20C9.60602 20 6.2486 20.0067 2.88452 19.9934C2.46485 19.9934 2.03185 19.9467 1.62549 19.8333C0.806124 19.5999 0.299846 19.0197 0.0533693 18.2128C-0.0732 17.7926 7.69859e-05 17.5859 0.379785 17.3458C3.48406 15.3918 6.58834 13.4378 9.69262 11.4838C10.019 11.2771 10.3654 11.2771 10.6919 11.4705C11.2781 11.8173 11.851 12.1774 12.4239 12.5442C12.8968 12.851 13.0967 12.8576 13.5563 12.5575C14.1625 12.1641 14.7754 11.7839 15.3816 11.3905C15.708 11.1771 16.0011 11.2438 16.3009 11.4372C17.2934 12.0774 18.286 12.7109 19.2852 13.3445C21.3237 14.6382 23.3688 15.9187 25.4072 17.2124C26.0334 17.6059 26.1333 17.9327 25.8269 18.5929C25.4072 19.4865 24.6478 19.8666 23.7218 19.98C23.4887 20.0067 23.2555 20.0067 23.0224 20.0067C19.6716 20 16.3209 20 12.9701 20Z"
                                                fill="white" />
                                            <path
                                                d="M0.0470467 15.3651C0.0470467 11.7773 0.0470467 8.24942 0.0470467 4.66156C2.85822 6.45549 5.62942 8.21608 8.44725 10.01C5.63608 11.8039 2.86488 13.5712 0.0470467 15.3651Z"
                                                fill="white" />
                                            <path
                                                d="M17.5732 10.01C20.3777 8.22275 23.1489 6.45549 25.9601 4.66156C25.9601 8.23608 25.9601 11.7573 25.9601 15.3518C23.1556 13.5712 20.3844 11.8039 17.5732 10.01Z"
                                                fill="white" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_12_171">
                                                <rect width="26" height="20" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="contact-desc">
                                    <p class="text-gradient mb-0 fs-14">E-mail address</p>
                                    <a href="mailto:jackie@gmail.com" class="text-white">jackie@gmail.com</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 mb-40">
                            <div class="contact-box d-flex align-items-center">
                                <div class="contact-icon d-flex justify-content-center align-items-center">
                                    <svg width="26" height="26" viewBox="0 0 26 26" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_12_163)">
                                            <path
                                                d="M5.24875 11.2533C7.38447 15.3496 10.4178 18.4566 14.4261 20.5898C14.5964 20.6825 14.9988 20.5743 15.169 20.4197C16.0821 19.5541 16.9797 18.673 17.8464 17.761C18.3261 17.2509 18.8523 17.1736 19.5178 17.2973C21.0964 17.5755 22.6904 17.8537 24.2845 18.0392C25.5535 18.1938 26.0023 18.6112 26.0023 19.9096C26.0023 21.3008 26.0023 22.6766 26.0023 24.0678C26.0023 25.5672 25.5226 26.0309 23.9904 26C13.0952 25.8145 3.34518 18.0856 0.776133 7.48157C0.327324 5.61118 0.188038 3.64804 0.0177999 1.71581C-0.0905334 0.571938 0.54399 0.0154578 1.68923 0.0154578C3.2059 0 4.72256 0 6.23923 0C7.35351 0 7.8178 0.510107 7.95709 1.62307C8.17375 3.26159 8.4678 4.90012 8.77732 6.52319C8.90113 7.21879 8.77732 7.77527 8.26661 8.26992C7.24518 9.25922 6.2547 10.2485 5.24875 11.2533Z"
                                                fill="white" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_12_163">
                                                <rect width="26" height="26" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="contact-desc">
                                    <p class="text-gradient mb-0 fs-14">Mobile Number</p>
                                    <a href="tel:+1 4078461474" class="text-white">+1 4078461474</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 mb-sm-0 mb-40">
                            <div class="contact-box d-flex align-items-center">
                                <div class="contact-icon d-flex justify-content-center align-items-center">
                                    <svg width="30" height="26" viewBox="0 0 30 26" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_12_151)">
                                            <path
                                                d="M0.390592 26C0.264594 25.7615 0.0629984 25.5355 0.0251991 25.2844C-0.0377996 24.8324 0.0251991 24.3679 -3.51807e-07 23.916C-0.0126001 23.5017 0.163796 23.2883 0.592188 23.3008C0.718185 23.3008 0.844183 23.3008 0.97018 23.3008C10.3318 23.3008 19.6808 23.3008 29.0424 23.3134C29.3574 23.3134 29.6724 23.4389 29.9874 23.5017C29.9874 24.3303 29.9874 25.1714 29.9874 26C20.1344 26 10.2562 26 0.390592 26Z"
                                                fill="white" />
                                            <path
                                                d="M15.0315 10.6461C18.3956 10.6461 21.7598 10.6461 25.1365 10.6461C27.0391 10.6461 27.9714 11.5877 27.984 13.4959C27.984 13.521 27.984 13.5336 27.984 13.5587C28.2108 14.6635 27.6943 15.2912 26.7115 15.718C25.7161 16.1449 24.7585 16.2328 23.8891 15.492C23.4607 15.128 23.1079 14.6886 22.7551 14.2492C22.289 13.6842 21.848 13.6717 21.3692 14.2241C21.0542 14.5881 20.7392 14.9522 20.3864 15.2661C19.391 16.1574 18.2948 16.2579 17.1735 15.5423C16.6695 15.2159 16.2159 14.8016 15.7749 14.3873C15.1701 13.8223 14.9055 13.8223 14.3133 14.4124C13.9731 14.7513 13.6203 15.0778 13.2297 15.354C11.9068 16.3081 10.7098 16.2453 9.47501 15.1907C9.28602 15.0275 9.10962 14.8518 8.94582 14.6635C8.10164 13.6968 7.92525 13.6968 7.08106 14.7011C5.93448 16.057 4.48551 16.3583 2.87275 15.6301C2.24276 15.3414 2.00336 14.902 2.06636 14.2492C2.10416 13.9353 2.14196 13.6215 2.10416 13.3201C1.88997 11.776 3.13734 10.621 4.75011 10.6335C8.16464 10.6712 11.5918 10.6461 15.0315 10.6461Z"
                                                fill="white" />
                                            <path
                                                d="M27.7322 21.606C19.2526 21.606 10.8107 21.606 2.33112 21.606C2.33112 20.2878 2.33112 18.9696 2.33112 17.6012C4.43527 18.3042 6.27484 17.8522 7.78681 16.2327C10.3068 18.6432 12.6251 18.3168 15.0569 16.1574C18.0682 18.7687 20.2354 18.1661 22.2891 16.1198C22.9821 16.8605 23.7381 17.5384 24.7713 17.802C25.7918 18.0657 26.7494 17.8522 27.7574 17.4254C27.7322 18.8315 27.7322 20.1874 27.7322 21.606Z"
                                                fill="white" />
                                            <path
                                                d="M13.2297 9.46596C13.2297 8.22308 13.2171 7.00531 13.2423 5.77499C13.2549 5.37325 13.5447 5.13472 13.9605 5.13472C14.6535 5.12217 15.3465 5.12217 16.0269 5.13472C16.5057 5.13472 16.7829 5.41092 16.7829 5.87542C16.8081 7.05553 16.7955 8.24819 16.7955 9.46596C15.5985 9.46596 14.4393 9.46596 13.2297 9.46596Z"
                                                fill="white" />
                                            <path
                                                d="M15.0189 0C15.3213 0.55239 15.6741 1.18011 16.0143 1.82038C16.1655 2.10913 16.3671 2.39788 16.4553 2.71173C16.6443 3.40222 16.3419 4.15548 15.8001 4.45678C15.2583 4.75809 14.4267 4.67021 13.9857 4.26847C13.5195 3.82907 13.3683 2.98793 13.6959 2.37277C14.1243 1.54418 14.5905 0.740705 15.0189 0Z"
                                                fill="white" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_12_151">
                                                <rect width="30" height="26" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="contact-desc">
                                    <p class="text-gradient mb-0 fs-14">Date of Birth</p>
                                    <p class="mb-0 text-white">12th June, 1990</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="contact-box d-flex align-items-center">
                                <div class="contact-icon d-flex justify-content-center align-items-center">
                                    <svg width="20" height="26" viewBox="0 0 20 26" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_12_142)">
                                            <path
                                                d="M9.99342 21.3251C9.65855 20.9328 9.33682 20.5605 9.02165 20.1849C7.32106 18.1393 5.71239 16.0232 4.3204 13.7461C3.69335 12.7233 3.14509 11.6602 2.67562 10.5502C1.81219 8.50119 1.95993 6.48571 2.912 4.53395C4.14312 2.01209 6.16216 0.509702 8.89361 0.0905097C13.0958 -0.55337 17.088 2.45811 17.7741 6.71375C17.9974 8.10882 17.784 9.41671 17.2488 10.6978C16.6513 12.1264 15.8798 13.4544 15.0394 14.7388C13.5391 17.0259 11.8614 19.1688 10.0755 21.2279C10.0558 21.2514 10.0328 21.2782 9.99342 21.3251ZM13.9429 7.37105C13.9461 5.151 12.1733 3.34344 9.9967 3.34344C7.81679 3.34344 6.04726 5.14765 6.04726 7.36769C6.04726 9.58774 7.81679 11.3953 9.99342 11.3953C12.17 11.3953 13.9396 9.59444 13.9429 7.37105Z"
                                                fill="white" />
                                            <path
                                                d="M6.92352 18.592C6.54269 18.649 6.16515 18.7027 5.79088 18.7698C4.66153 18.9676 3.55517 19.246 2.51117 19.7457C2.10408 19.9435 1.71669 20.1716 1.39824 20.5036C0.886091 21.0401 0.886091 21.5901 1.41137 22.1166C1.85786 22.566 2.41268 22.8276 2.98721 23.0556C4.10014 23.4916 5.26232 23.7297 6.44092 23.8906C8.066 24.1153 9.70093 24.169 11.3391 24.0885C13.1743 23.9979 14.9898 23.7632 16.7397 23.1529C17.2584 22.9718 17.764 22.7571 18.2105 22.4218C18.4107 22.2709 18.6044 22.0965 18.7587 21.8986C19.0575 21.5163 19.0673 21.0904 18.7587 20.7182C18.5486 20.4633 18.2892 20.2319 18.0135 20.0508C17.242 19.5444 16.3753 19.256 15.4888 19.0481C14.7535 18.8771 14.0082 18.7664 13.2663 18.6289C13.2006 18.6155 13.1382 18.6054 13.0726 18.5954C13.194 18.3338 13.217 18.3271 13.4829 18.3472C14.5795 18.4344 15.6727 18.5551 16.7462 18.8C17.3306 18.9307 17.9084 19.0884 18.437 19.3734C18.7686 19.5511 19.0969 19.7591 19.3693 20.0139C20.0686 20.6712 20.1934 21.5834 19.7469 22.4419C19.5072 22.9047 19.156 23.2702 18.7554 23.5888C17.8822 24.283 16.8874 24.7424 15.8434 25.0945C13.6471 25.8357 11.3851 26.0805 9.08045 25.9799C7.31091 25.8994 5.58077 25.6076 3.90645 24.9973C2.87559 24.6217 1.89397 24.1522 1.05352 23.4144C0.685829 23.0925 0.373944 22.7169 0.176964 22.2575C-0.154618 21.4828 -0.00360029 20.6645 0.57749 20.0642C1.06337 19.5612 1.67729 19.2829 2.31748 19.0649C3.19404 18.7664 4.10014 18.6122 5.01281 18.4981C5.5184 18.4344 6.02398 18.3975 6.53284 18.3439C6.77907 18.3204 6.79876 18.3338 6.92352 18.592Z"
                                                fill="white" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_12_142">
                                                <rect width="20" height="26" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="contact-desc">
                                    <p class="text-gradient mb-0 fs-14">Address</p>
                                    <p class="text-white mb-0">New York, USA</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="our-services-section px-30">
                <div class="center-heading text-center pb-sm-3">
                    <h2 class="text-white text-center mb-3">Our Services</h2>
                </div>

                <div class="services py-4">
                    <div class="row">
                        <div class="col-12 mb-40">
                            <div class="service-card d-flex flex-row">
                                <div class="card-img d-flex justify-content-center align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="36" height="28"
                                        viewBox="0 0 36 28" fill="none">
                                        <g clip-path="url(#clip0_37_155)">
                                            <path
                                                d="M0 25.2152C0 19.6437 0 14.0722 0 8.50075C0.0704501 8.49791 0.139961 8.49225 0.210411 8.49225C12.0301 8.49225 23.8506 8.49225 35.6703 8.49225C35.7717 8.49225 35.8732 8.50452 35.9822 8.51208C35.9897 8.58007 35.9991 8.6254 35.9991 8.67072C35.9991 14.0628 36.0056 19.4558 35.985 24.8478C35.9831 25.2803 35.8647 25.7478 35.6769 26.1387C35.0513 27.4372 33.9767 28.0009 32.5508 27.999C22.8625 27.9896 13.1751 27.9943 3.48681 27.9943C3.35812 27.9943 3.22943 27.9934 3.10074 27.9887C1.75374 27.9386 0.590841 27.067 0.166262 25.7856C0.103327 25.5976 0.0544814 25.405 0 25.2152ZM9.16509 22.2557C8.06419 22.2557 7.01589 22.2557 5.95632 22.2557C5.95632 20.9289 5.95632 19.6277 5.95632 18.2905C6.51992 18.2905 7.05628 18.2981 7.59264 18.2877C8.0191 18.2792 8.32908 18.062 8.50568 17.6767C8.67663 17.3056 8.63624 16.9382 8.39577 16.6058C8.16188 16.2829 7.82654 16.1686 7.44423 16.1677C6.95389 16.1667 6.46356 16.1677 5.95726 16.1677C5.95726 15.1506 5.95726 14.1695 5.95726 13.1619C6.48798 13.1619 6.99053 13.1695 7.49307 13.16C8.15061 13.1468 8.60806 12.6973 8.60337 12.0854C8.59867 11.4735 8.14027 11.0438 7.47429 11.0391C6.70121 11.0334 5.92814 11.0372 5.15507 11.0381C4.18568 11.0381 3.82027 11.4064 3.81933 12.3847C3.81933 15.9363 3.81933 19.4888 3.81933 23.0404C3.81933 24.0329 4.18943 24.405 5.17949 24.4059C8.54231 24.4069 11.9042 24.4069 15.267 24.405C15.4192 24.405 15.5723 24.4031 15.7226 24.3804C16.2186 24.3049 16.5915 23.93 16.6027 23.4257C16.6243 22.4701 16.6243 21.5144 16.6027 20.5588C16.5905 20.0422 16.1979 19.6598 15.6906 19.5946C15.2163 19.5332 14.7325 19.8203 14.5841 20.2802C14.5268 20.4558 14.5146 20.6504 14.5108 20.8373C14.5014 21.3057 14.508 21.775 14.508 22.2585C13.4146 22.2585 12.3673 22.2585 11.2739 22.2585C11.2739 22.1112 11.2739 21.9856 11.2739 21.8591C11.272 21.4341 11.2842 21.0092 11.2645 20.5852C11.242 20.0875 10.9104 19.7108 10.4435 19.6107C9.77753 19.469 9.19515 19.9421 9.16978 20.6683C9.151 21.1848 9.16509 21.7033 9.16509 22.2557ZM25.1939 17.8438C23.4495 17.8438 21.7043 17.8429 19.9599 17.8438C19.1474 17.8448 18.7388 18.2414 18.736 19.0488C18.7303 20.4284 18.7313 21.8081 18.736 23.1887C18.7388 23.9744 19.1493 24.4012 19.9233 24.4021C23.4355 24.4069 26.9486 24.4078 30.4607 24.4021C31.2432 24.4012 31.6434 23.9791 31.6443 23.1906C31.6462 21.8109 31.6462 20.4313 31.6443 19.0507C31.6434 18.2461 31.2376 17.8448 30.4269 17.8438C28.6835 17.8429 26.9382 17.8438 25.1939 17.8438ZM25.1911 13.1619C26.9241 13.1619 28.6582 13.1638 30.3912 13.1591C30.565 13.1591 30.7454 13.1449 30.9107 13.0967C31.3653 12.9645 31.6603 12.5292 31.6434 12.0514C31.6274 11.5802 31.2902 11.159 30.8318 11.0646C30.673 11.0315 30.5058 11.0381 30.3424 11.0381C26.911 11.0372 23.4796 11.0372 20.0482 11.0372C19.9308 11.0372 19.8134 11.0344 19.6969 11.0438C19.1981 11.0853 18.8064 11.4735 18.7491 11.9777C18.6937 12.4612 18.9793 12.9381 19.4395 13.0854C19.6142 13.1411 19.8077 13.1572 19.9919 13.1581C21.7249 13.1638 23.458 13.1619 25.1911 13.1619ZM22.4802 16.4415C23.3462 16.4415 24.2113 16.4434 25.0774 16.4406C25.7735 16.4387 26.2328 16.0213 26.2394 15.3962C26.245 14.7691 25.7829 14.3206 25.1018 14.3187C23.3584 14.313 21.615 14.313 19.8716 14.3187C19.2141 14.3215 18.7472 14.7672 18.7397 15.3716C18.7322 15.9901 19.2056 16.4368 19.8829 16.4396C20.748 16.4444 21.6141 16.4415 22.4802 16.4415Z"
                                                fill="url(#paint0_linear_37_155)" />
                                            <path
                                                d="M-0.000157391 2.76407C0.057142 2.57521 0.109745 2.38445 0.17268 2.19748C0.622622 0.869768 1.82497 0.00760486 3.25933 0.00382758C5.96556 -0.00278265 8.67178 0.00193895 11.378 0.00193895C18.4305 0.00193895 25.4831 0.00193895 32.5356 0.00193895C34.6613 0.00193895 35.9989 1.35137 35.9998 3.49309C35.9998 4.43552 35.9998 5.37794 35.9998 6.36759C35.827 6.36759 35.6795 6.36759 35.5311 6.36759C23.8392 6.36759 12.1473 6.36759 0.45542 6.36759C0.303248 6.36759 0.151076 6.37326 -0.00109673 6.37609C-0.000157391 5.17208 -0.000157391 3.96808 -0.000157391 2.76407ZM4.02771 2.24847C4.02771 2.24942 4.02771 2.25036 4.02771 2.25036C3.73558 2.25036 3.4425 2.23431 3.15131 2.25414C2.62247 2.29002 2.21385 2.71969 2.1838 3.24378C2.15468 3.76222 2.51538 4.27876 3.04141 4.32314C3.69049 4.37791 4.35084 4.3798 4.99898 4.32503C5.54849 4.27876 5.89511 3.76883 5.85566 3.2164C5.81714 2.68664 5.41135 2.28058 4.87029 2.25036C4.58943 2.23525 4.30763 2.24847 4.02771 2.24847ZM8.74787 2.24942C8.45573 2.24942 8.16266 2.23525 7.87147 2.25225C7.33981 2.28436 6.92556 2.70552 6.89174 3.22773C6.85699 3.75372 7.20548 4.27404 7.73057 4.31936C8.38998 4.37697 9.06254 4.37697 9.72196 4.32031C10.2527 4.27498 10.589 3.7726 10.5598 3.23245C10.5317 2.70458 10.1259 2.2853 9.58857 2.25225C9.31053 2.23525 9.02873 2.24942 8.74787 2.24942ZM13.4107 4.36469C13.4107 4.36375 13.4107 4.36375 13.4107 4.3628C13.6916 4.3628 13.9734 4.38074 14.2524 4.35903C14.8686 4.31086 15.28 3.85854 15.2669 3.27023C15.2537 2.68569 14.8132 2.25886 14.1923 2.24658C13.6897 2.2362 13.1862 2.23714 12.6837 2.24658C12.0637 2.25792 11.6157 2.68192 11.5969 3.25984C11.5771 3.85759 12.0055 4.31842 12.6386 4.36091C12.896 4.37886 13.1543 4.36469 13.4107 4.36469Z"
                                                fill="url(#paint1_linear_37_155)" />
                                            <path
                                                d="M20.8636 22.251C20.8636 21.4794 20.8636 20.741 20.8636 19.9855C23.7492 19.9855 26.6142 19.9855 29.5073 19.9855C29.5073 20.7297 29.5073 21.4766 29.5073 22.251C26.6414 22.251 23.7689 22.251 20.8636 22.251Z"
                                                fill="url(#paint2_linear_37_155)" />
                                        </g>
                                        <defs>
                                            <linearGradient id="paint0_linear_37_155" x1="0" y1="8.49225"
                                                x2="18.5061" y2="38.712" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932" />
                                                <stop offset="1" stop-color="#FF5A0E" />
                                            </linearGradient>
                                            <linearGradient id="paint1_linear_37_155" x1="-0.00109673"
                                                y1="0.000305176" x2="2.61256" y2="13.0586"
                                                gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932" />
                                                <stop offset="1" stop-color="#FF5A0E" />
                                            </linearGradient>
                                            <linearGradient id="paint2_linear_37_155" x1="20.8636" y1="19.9855"
                                                x2="22.1777" y2="24.422" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932" />
                                                <stop offset="1" stop-color="#FF5A0E" />
                                            </linearGradient>
                                            <clipPath id="clip0_37_155">
                                                <rect width="36" height="28" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="card-body p-0">
                                    <h3 class="card-title fs-18 text-white">Web Design</h3>
                                    <p class="mb-0 fs-14 text-gray-100">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore et dolore.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="service-card d-flex flex-row">
                                <div class="card-img d-flex justify-content-center align-items-center">
                                    <svg width="28" height="28" viewBox="0 0 28 28" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_37_170)">
                                            <path
                                                d="M27.9975 19.9999C26.296 19.9999 24.6411 19.9915 22.9862 20.0024C21.5944 20.0116 20.4226 20.9347 20.0953 22.2735C20.027 22.5531 20.0045 22.8494 20.0028 23.1382C19.9937 24.7207 19.9979 26.304 19.997 27.8865C19.997 27.9065 19.9912 27.9274 19.9804 27.9967C19.8896 27.9967 19.7913 27.9967 19.6922 27.9967C18.1722 27.9967 16.6514 27.9984 15.1314 27.9958C13.295 27.9933 12.0024 26.7063 12.0015 24.8734C11.999 20.292 11.999 15.7098 12.0015 11.1284C12.0024 9.293 13.2933 8.00263 15.1264 8.00096C18.3754 7.99846 21.6244 7.99846 24.8734 8.00096C26.7091 8.00263 27.9958 9.28966 27.9975 11.1276C28.0008 13.9804 27.9983 16.8341 27.9983 19.6869C27.9975 19.7804 27.9975 19.8722 27.9975 19.9999ZM20.0287 12.0014C19.06 12.0014 18.0923 12.0006 17.1236 12.0014C16.4565 12.0023 16.0051 12.4029 16.0018 12.9938C15.9984 13.5839 16.4532 13.9996 17.112 14.0004C19.0384 14.0021 20.964 14.0021 22.8904 14.0004C23.5475 13.9996 24.0031 13.5814 23.9981 12.9913C23.9931 12.4146 23.5408 12.0031 22.9029 12.0014C21.9442 11.9998 20.9865 12.0014 20.0287 12.0014ZM18.9943 18.0001C19.6505 18.0001 20.306 18.0051 20.9623 17.9984C21.5511 17.9926 21.9917 17.5677 21.9984 17.0127C22.005 16.4451 21.5595 16.0044 20.9565 16.0019C19.6547 15.9969 18.3538 15.9977 17.052 16.0019C16.4424 16.0036 16.0001 16.4318 16.0009 17.0027C16.0018 17.5702 16.4482 17.9951 17.0578 17.9992C17.7033 18.0034 18.3488 18.0001 18.9943 18.0001Z"
                                                fill="url(#paint0_linear_37_170)" />
                                            <path
                                                d="M0.00333064 21.9763C0.00333064 20.686 0.00083205 19.3948 0.0041635 18.1044C0.00666209 16.8524 0.851185 16.0028 2.09715 16.0011C4.03272 15.9986 5.96913 15.9986 7.9047 16.0011C9.15149 16.0028 9.99851 16.8516 10.0002 18.1027C10.0027 20.7052 10.0035 23.3068 10.0002 25.9092C9.99851 27.1412 9.14816 27.995 7.92219 27.9975C5.97579 28.0017 4.02939 28.0017 2.08299 27.9975C0.856182 27.995 0.00666209 27.1412 0.00333064 25.9117C0.00083205 24.5997 0.00333064 23.2884 0.00333064 21.9763ZM4.00274 21.9839C4.00274 22.3277 3.99441 22.6708 4.0044 23.0147C4.02106 23.573 4.46664 24.0029 5.00967 23.9979C5.54103 23.9937 5.98495 23.573 5.99661 23.0288C6.01077 22.3419 6.0116 21.655 5.99661 20.9681C5.98495 20.4247 5.53937 20.0041 5.008 20.0007C4.46164 19.9974 4.02106 20.4231 4.0044 20.9848C3.99524 21.3178 4.00274 21.6508 4.00274 21.9839Z"
                                                fill="url(#paint1_linear_37_170)" />
                                            <path
                                                d="M21.1097 0.0033489C22.6922 0.0033489 24.2738 0.00251425 25.8562 0.0033489C27.1663 0.00418355 27.9958 0.837164 27.9983 2.15341C27.9992 2.76771 28.0042 3.38201 27.9967 3.99548C27.9825 5.12726 27.1238 5.99697 25.9936 5.99947C22.7355 6.00698 19.4782 6.00782 16.22 5.99279C15.9185 5.99112 15.6012 5.90098 15.3188 5.78413C14.6176 5.49534 13.9313 5.1715 13.2425 4.8535C12.4505 4.48792 12.0065 3.86861 12.0099 2.99223C12.0132 2.13004 12.4513 1.51657 13.2317 1.15683C13.9205 0.838833 14.6051 0.509981 15.3088 0.22787C15.6287 0.0993336 15.9893 0.0175379 16.3333 0.01253C17.9249 -0.00917084 19.5173 0.0033489 21.1097 0.0033489Z"
                                                fill="url(#paint2_linear_37_170)" />
                                            <path
                                                d="M8.86245 13.8509C8.54679 13.9069 8.28777 13.992 8.02708 13.9937C6.00656 14.0045 3.98604 14.0095 1.96634 13.9962C0.887786 13.9887 0.0116145 13.1206 0.00828304 12.0439C-0.00254418 8.68028 -0.00337704 5.31665 0.00828304 1.95301C0.0124473 0.892169 0.882789 0.0174567 1.94219 0.00911017C3.98354 -0.00674817 6.02488 -7.09744e-05 8.0654 0.0116141C8.31442 0.0132834 8.56261 0.101756 8.86911 0.161851C8.43602 0.640105 8.05957 1.0566 7.68145 1.47142C6.64537 2.61238 5.60595 3.75084 4.57154 4.89264C3.40969 6.17466 3.41303 7.84063 4.5757 9.1168C5.92161 10.5958 7.26585 12.0756 8.61092 13.5555C8.67838 13.6306 8.74251 13.7099 8.86245 13.8509Z"
                                                fill="url(#paint3_linear_37_170)" />
                                            <path
                                                d="M9.9727 12.079C8.73673 10.7211 7.55906 9.38645 6.33558 8.09525C5.49689 7.20969 5.52854 6.76398 6.33558 5.91014C7.55739 4.61726 8.7359 3.28433 9.9727 1.92468C9.9727 5.32421 9.9727 8.67116 9.9727 12.079Z"
                                                fill="url(#paint4_linear_37_170)" />
                                            <path
                                                d="M27.3079 21.9997C25.5306 23.7725 23.7724 25.5244 22.0184 27.2738C22.0151 27.243 22.0001 27.1678 22.0001 27.0927C21.9984 25.7606 21.9976 24.4277 22.0001 23.0956C22.0017 22.4095 22.4032 22.0022 23.0819 22.0005C24.4861 21.9972 25.8912 21.9997 27.3079 21.9997Z"
                                                fill="url(#paint5_linear_37_170)" />
                                        </g>
                                        <defs>
                                            <linearGradient id="paint0_linear_37_170" x1="11.9997" y1="7.99908"
                                                x2="32.0887" y2="22.2203" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932" />
                                                <stop offset="1" stop-color="#FF5A0E" />
                                            </linearGradient>
                                            <linearGradient id="paint1_linear_37_170" x1="0.00222015" y1="15.9992"
                                                x2="12.2132" y2="25.0021" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932" />
                                                <stop offset="1" stop-color="#FF5A0E" />
                                            </linearGradient>
                                            <linearGradient id="paint2_linear_37_170" x1="12.0099"
                                                y1="-0.000244141" x2="16.6101" y2="10.839"
                                                gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932" />
                                                <stop offset="1" stop-color="#FF5A0E" />
                                            </linearGradient>
                                            <linearGradient id="paint3_linear_37_170" x1="-0.000152588"
                                                y1="-0.000244141" x2="12.7219" y2="7.12889"
                                                gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932" />
                                                <stop offset="1" stop-color="#FF5A0E" />
                                            </linearGradient>
                                            <linearGradient id="paint4_linear_37_170" x1="5.71838" y1="1.92468"
                                                x2="12.7682" y2="4.53814" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932" />
                                                <stop offset="1" stop-color="#FF5A0E" />
                                            </linearGradient>
                                            <linearGradient id="paint5_linear_37_170" x1="21.9985" y1="21.9988"
                                                x2="27.5793" y2="26.969" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932" />
                                                <stop offset="1" stop-color="#FF5A0E" />
                                            </linearGradient>
                                            <clipPath id="clip0_37_170">
                                                <rect width="28" height="28" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="card-body p-0">
                                    <h3 class="card-title fs-18 text-white">Branding Design</h3>
                                    <p class="mb-0 fs-14 text-gray-100">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore et dolore.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="appointment-section pt-60 pb-60">
                <div class="section-heading">
                    <h2 class="text-white mb-0 d-inline-block">Make an Appointment</h2>
                </div>

                <div class="appointment px-30 mt-3 pt-3">
                    <div class="row mb-3 pb-2">
                        <div class="col-sm-2">
                            <label for="date"
                                class="appoint-date text-white fs-20 mt-sm-2 mb-sm-0 mb-2">Date:</label>
                        </div>
                        <div class="col-sm-10">
                            <div class="position-relative">
                                <input type="text" class="form-control appointment-input"
                                    placeholder="Pick a Date" />
                                <span class="calendar-icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M6.25 9.375V10.625C6.25 10.9705 5.97047 11.25 5.625 11.25H4.375C4.02953 11.25 3.75 10.9705 3.75 10.625V9.375C3.75 9.02953 4.02953 8.75 4.375 8.75H5.625C5.97047 8.75 6.25 9.02953 6.25 9.375ZM5.625 13.75H4.375C4.02953 13.75 3.75 14.0295 3.75 14.375V15.625C3.75 15.9705 4.02953 16.25 4.375 16.25H5.625C5.97047 16.25 6.25 15.9705 6.25 15.625V14.375C6.25 14.0295 5.97047 13.75 5.625 13.75ZM10.625 8.75H9.375C9.02953 8.75 8.75 9.02953 8.75 9.375V10.625C8.75 10.9705 9.02953 11.25 9.375 11.25H10.625C10.9705 11.25 11.25 10.9705 11.25 10.625V9.375C11.25 9.02953 10.9705 8.75 10.625 8.75ZM10.625 13.75H9.375C9.02953 13.75 8.75 14.0295 8.75 14.375V15.625C8.75 15.9705 9.02953 16.25 9.375 16.25H10.625C10.9705 16.25 11.25 15.9705 11.25 15.625V14.375C11.25 14.0295 10.9705 13.75 10.625 13.75ZM15.625 8.75H14.375C14.0295 8.75 13.75 9.02953 13.75 9.375V10.625C13.75 10.9705 14.0295 11.25 14.375 11.25H15.625C15.9705 11.25 16.25 10.9705 16.25 10.625V9.375C16.25 9.02953 15.9705 8.75 15.625 8.75ZM15.625 13.75H14.375C14.0295 13.75 13.75 14.0295 13.75 14.375V15.625C13.75 15.9705 14.0295 16.25 14.375 16.25H15.625C15.9705 16.25 16.25 15.9705 16.25 15.625V14.375C16.25 14.0295 15.9705 13.75 15.625 13.75ZM4.375 3.75H5.625C5.97047 3.75 6.25 3.47047 6.25 3.125V0.625C6.25 0.279531 5.97047 0 5.625 0H4.375C4.02953 0 3.75 0.279531 3.75 0.625V3.125C3.75 3.47047 4.02953 3.75 4.375 3.75ZM20 5V17.5C20 18.8806 18.8806 20 17.5 20H2.5C1.11937 20 0 18.8806 0 17.5V5C0 3.61937 1.11937 2.5 2.5 2.5H3.125V3.125C3.125 3.81348 3.6859 4.375 4.375 4.375H5.625C6.3141 4.375 6.875 3.81348 6.875 3.125V2.5H13.125V3.125C13.125 3.81348 13.6865 4.375 14.375 4.375H15.625C16.3135 4.375 16.875 3.81348 16.875 3.125V2.5H17.5C18.8806 2.5 20 3.61937 20 5ZM18.75 7.5C18.75 6.81152 18.1897 6.25 17.5 6.25H2.5C1.8109 6.25 1.25 6.81152 1.25 7.5V17.5C1.25 18.1897 1.8109 18.75 2.5 18.75H17.5C18.1897 18.75 18.75 18.1897 18.75 17.5V7.5ZM14.375 3.75H15.625C15.9705 3.75 16.25 3.47047 16.25 3.125V0.625C16.25 0.279531 15.9705 0 15.625 0H14.375C14.0295 0 13.75 0.279531 13.75 0.625V3.125C13.75 3.47047 14.0295 3.75 14.375 3.75Z"
                                            fill="#A9AFB8" />
                                    </svg>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-2">
                            <label class="text-white fs-20 mt-sm-2 mb-sm-0 mb-2">Hour:</label>
                        </div>
                        <div class="col-sm-10">
                            <div class="row">
                                <div class="col-sm-6 mb-2 pe-sm-1">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-gray-100">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-sm-6 mb-2 ps-sm-1">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-gray-100">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-sm-6 mb-2 pe-sm-1">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-gray-100">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-sm-6 mb-2 ps-sm-1">
                                    <div class="hour-input d-flex justify-content-center align-items-center">
                                        <span class="text-gray-100">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-12 mt-3">
                                    <button type="submit"
                                        class="btn-gradient w-100 rounded-2 justify-content-center text-center">
                                        Make an Appointment
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="gallery-section pb-40 px-30">
                <h2 class="text-white text-center mb-3 pb-3">Gallery</h2>
                <div class="gallery-slider">
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard14/gallery-img1.png') }}" />
                            <a id="play-video" class="video-play-button" href="#">
                                <span></span>
                            </a>
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard14/gallery-img1.png') }}" />
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard14/gallery-img1.png') }}" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="product-section">
                <div class="section-heading mb-3">
                    <h2 class="text-white mb-0 d-inline-block">Products</h2>
                </div>
                <div class="px-30">
                    <div class="product-slider">
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="{{ asset('assets/img/vcard14/product-img1.png') }}"
                                        class="img-fluid h-100" />
                                </div>
                                <div class="product-desc card-body">
                                    <div class="d-flex justify-content-between">
                                        <div class="product-title">
                                            <h3 class="text-white fs-18 fw-7">Laptop</h3>
                                        </div>
                                        <div class="product-amount">$200</div>
                                    </div>
                                    <p class="fs-14 text-gray-100 mb-0">
                                        Dell Inspiron Core i3 11th Gen
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="{{ asset('assets/img/vcard14/product-img2.png') }}"
                                        class="img-fluid h-100" />
                                </div>
                                <div class="product-desc card-body">
                                    <div class="d-flex justify-content-between">
                                        <div class="product-title">
                                            <h3 class="text-white fs-18 fw-7">Laptop</h3>
                                        </div>
                                        <div class="product-amount">$200</div>
                                    </div>
                                    <p class="fs-14 text-gray-100 mb-0">
                                        Dell Inspiron Core i3 11th Gen
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="{{ asset('assets/img/vcard14/product-img1.png') }}"
                                        class="img-fluid h-100" />
                                </div>
                                <div class="product-desc card-body">
                                    <div class="d-flex justify-content-between">
                                        <div class="product-title">
                                            <h3 class="text-white fs-18 fw-7">Laptop</h3>
                                        </div>
                                        <div class="product-amount">$200</div>
                                    </div>
                                    <p class="fs-14 text-gray-100 mb-0">
                                        Dell Inspiron Core i3 11th Gen
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card">
                                <div class="product-img card-img">
                                    <img src="{{ asset('assets/img/vcard14/product-img2.png') }}"
                                        class="img-fluid h-100" />
                                </div>
                                <div class="product-desc card-body">
                                    <div class="d-flex justify-content-between">
                                        <div class="product-title">
                                            <h3 class="text-white fs-18 fw-7">Laptop</h3>
                                        </div>
                                        <div class="product-amount">$200</div>
                                    </div>
                                    <p class="fs-14 text-gray-100 mb-0">
                                        Dell Inspiron Core i3 11th Gen
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="testimonial-section pt-60 pb-60">
                <h2 class="text-white text-center mb-3 pb-3">Testimonial</h2>
                <div class="px-30">
                    <div class="testimonial-slider">
                        <div class="">
                            <div class="testimonial-card position-relative">
                                <div class="quote-left-img quote-img d-flex justify-content-center align-items-center">
                                    <img src="{{ asset('assets/img/vcard14/quote-left.png') }}" class="img-fluid" />
                                </div>
                                <div
                                    class="quote-right-img quote-img d-flex justify-content-center align-items-center">
                                    <img src="{{ asset('assets/img/vcard14/quote-right.png') }}" class="img-fluid" />
                                </div>
                                <div class="card-body p-0">
                                    <div class="text-sm-start text-center">
                                        <p class="desc text-gray-100">
                                            Lorem Ipsum is simply dummy text of the printing and
                                            typesetting industry. Lorem Ipsum has been the
                                            industry's standard dummy text.
                                        </p>
                                        <div
                                            class="d-flex align-items-center justify-content-sm-start justify-content-center">
                                            <div class="profile-img me-3">
                                                <img src="{{ asset('assets/img/vcard14/testimonial-profile-img.png') }}"
                                                    class="img-fluid h-100" />
                                            </div>
                                            <div>
                                                <h6 class="fs-6 fw-7 text-white mb-0">
                                                    Shane Watson
                                                </h6>
                                                <span class="fs-12 text-gradient">- CEO at Tarsons</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="testimonial-card position-relative">
                                <div class="quote-left-img quote-img d-flex justify-content-center align-items-center">
                                    <img src="{{ asset('assets/img/vcard14/quote-left.png') }}" class="img-fluid" />
                                </div>
                                <div
                                    class="quote-right-img quote-img d-flex justify-content-center align-items-center">
                                    <img src="{{ asset('assets/img/vcard14/quote-right.png') }}" class="img-fluid" />
                                </div>
                                <div class="card-body p-0">
                                    <div class="text-sm-start text-center">
                                        <p class="desc text-gray-100">
                                            Lorem Ipsum is simply dummy text of the printing and
                                            typesetting industry. Lorem Ipsum has been the
                                            industry's standard dummy text.
                                        </p>
                                        <div
                                            class="d-flex align-items-center justify-content-sm-start justify-content-center">
                                            <div class="profile-img me-3">
                                                <img src="{{ asset('assets/img/vcard14/testimonial-profile-img.png') }}"
                                                    class="img-fluid h-100" />
                                            </div>
                                            <div>
                                                <h6 class="fs-6 fw-7 text-white mb-0">
                                                    Shane Watson
                                                </h6>
                                                <span class="fs-12 text-gradient">- CEO at Tarsons</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="blog-section">
                <div class="section-heading mb-3">
                    <h2 class="text-white mb-0 d-inline-block">Blog</h2>
                </div>
                <div class="center-slider pt-sm-0 pt-3">
                    <div>
                        <div class="blog-card">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard14/blog-img1.png') }}" class="h-100" />
                            </div>
                            <div class="card-body">
                                <h5 class="text-white fs-18 mb-1">Men's Wear</h5>
                                <p class="text-gray-100 mb-0 fs-12">
                                    Lorem Ipsum is simply dummy text of the printing and
                                    typesetting industry. Lorem Ipsum has been the industry's
                                    standard dummy text.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="blog-card">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard14/blog-img2.png') }}" class="h-100" />
                            </div>
                            <div class="card-body">
                                <h5 class="text-white fs-18 mb-1">Watson's Wear</h5>
                                <p class="text-gray-100 mb-0 fs-12">
                                    Lorem Ipsum is simply dummy text of the printing and
                                    typesetting industry. Lorem Ipsum has been the industry's
                                    standard dummy text.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="blog-card">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard14/blog-img3.png') }}" class="h-100" />
                            </div>
                            <div class="card-body">
                                <h5 class="text-white fs-18 mb-1">Men's Wear</h5>
                                <p class="text-gray-100 mb-0 fs-12">
                                    Lorem Ipsum is simply dummy text of the printing and
                                    typesetting industry. Lorem Ipsum has been the industry's
                                    standard dummy text.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="qr-code-section pt-60 position-relative">
                <div class="pb-3">
                    <h2 class="text-white text-center mb-0 pb-3">QR Code</h2>
                </div>
                <div class="px-30">
                    <div class="qr-code d-flex justify-content-center position-relative">
                        <div class="qr-profile-img">
                            <img src="{{ asset('assets/img/vcard14/qr-code-profile.png') }}" />
                        </div>
                        <div class="qr-code-img">
                            <img src="{{ asset('assets/img/vcard14/qr-code.png') }}" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="bussiness-hour-section pt-60 pb-60">
                <div class="section-heading">
                    <h2 class="text-white mb-0 d-inline-block">Business Hours</h2>
                </div>
                <div class="px-30">
                    <div class="bussiness-hour-card">
                        <div class="mb-10 d-flex align-items-center justify-content-between">
                            <span class="me-2">Sunday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                        <div class="mb-10 d-flex align-items-center justify-content-between">
                            <span class="me-2">Monday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                        <div class="mb-10 d-flex align-items-center justify-content-between">
                            <span class="me-2">Tueday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                        <div class="mb-10 d-flex align-items-center justify-content-between">
                            <span class="me-2">Wednesday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                        <div class="mb-10 d-flex align-items-center justify-content-between">
                            <span class="me-2">Thursday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                        <div class="mb-10 d-flex align-items-center justify-content-between">
                            <span class="me-2">Friday:</span>
                            <span>08:10 - 20:00</span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between">
                            <span class="me-2">Saturday:</span>
                            <span>Closed</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="contact-us-section px-30">
                <div class="center-heading text-center pb-sm-3">
                    <h2 class="text-white text-center mb-3">Contact Us</h2>
                </div>
                <div class="contact-form">
                    <form action="">
                        <div class="row">
                            <div class="col-sm-6 pe-sm-1">
                                <input type="text" class="form-control" placeholder="Full Name" />
                            </div>
                            <div class="col-sm-6 ps-sm-1">
                                <input type="tel" class="form-control" placeholder="Phone Number" />
                            </div>
                            <div class="col-12">
                                <input type="email" class="form-control" placeholder="Email Address" />
                            </div>

                            <div class="col-12">
                                <textarea class="form-control h-100" placeholder="Type a Message..." rows="3"></textarea>
                            </div>
                            <div class="col-12 text-center mt-4">
                                <button class="w-50 btn-gradient rounded-2" type="submit">
                                    Send Message
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="create-vcard-section pt-60 pb-60">
                <div class="section-heading mb-3 pb-3">
                    <h2 class="text-white mb-0 d-inline-block">Create Your VCard</h2>
                </div>
                <div class="row justify-content-end">
                    <div class="col-11">
                        <div class="vcard-link-card card">
                            <div class="d-flex align-items-center text-center">
                                <a href="https://vcards.infyom.com/marlonbrasil"
                                    class="text-white link-text">https://vcards.infyom.com/marlonbrasil</a>
                                <i class="icon fa-solid fa-arrow-up-right-from-square ms-3 share-icon"
                                    ></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="add-to-conact-section pb-40 px-30">
                <div class="text-center">
                    <button class="rounded-2 w-50 btn-gradient">Add to Contact</button>
                </div>
            </div>
            <div class="btn-section cursor-pointer">
                <div class="fixed-btn-section">
                    {{-- <div class="bars-btn event-bars-btn">
                        <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M15.4134 0.540771H22.489C23.572 0.540771 24.4601 1.42891 24.4601 2.51188V9.5875C24.4601 10.6776 23.5731 11.5586 22.489 11.5586H15.4134C14.3222 11.5586 13.4423 10.6787 13.4423 9.5875V2.51188C13.4423 1.42783 14.3233 0.540771 15.4134 0.540771Z"
                                stroke="white" />
                            <path
                                d="M2.97143 0.5H8.74589C10.1129 0.5 11.2173 1.6122 11.2173 2.97143V8.74589C11.2173 10.1139 10.1139 11.2173 8.74589 11.2173H2.97143C1.6122 11.2173 0.5 10.1129 0.5 8.74589V2.97143C0.5 1.61328 1.61328 0.5 2.97143 0.5Z"
                                stroke="white" />
                            <path
                                d="M2.97143 13.783H8.74589C10.1139 13.783 11.2173 14.8863 11.2173 16.2544V22.0289C11.2173 23.3881 10.1129 24.5003 8.74589 24.5003H2.97143C1.61328 24.5003 0.5 23.387 0.5 22.0289V16.2544C0.5 14.8874 1.6122 13.783 2.97143 13.783Z"
                                stroke="white" />
                            <path
                                d="M16.2537 13.783H22.0282C23.3874 13.783 24.4996 14.8874 24.4996 16.2544V22.0289C24.4996 23.387 23.3863 24.5003 22.0282 24.5003H16.2537C14.8867 24.5003 13.7823 23.3881 13.7823 22.0289V16.2544C13.7823 14.8863 14.8856 13.783 16.2537 13.783Z"
                                stroke="white" />
                        </svg>
                    </div>
                    <div class="sub-btn">
                        <div class="social-btn event-sub-btn wp-btn">
                            <i class="fa-brands fa-whatsapp text-gradient"></i>
                        </div>
                        <div class="social-btn event-sub-btn wp-btn mt-3">
                            <i class="fa-solid fa-share-nodes text-gradient"></i>
                        </div>
                    </div> --}}
                </div>
            </div>
        </div>
    </div>
</body>
<script src="https://js.stripe.com/v3/"></script>
<script type="text/javascript" src="{{ asset('assets/js/front-third-party.js') }}"></script>
<script type="text/javascript" src="{{ asset('front/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('assets/js/slider/js/slick.min.js') }}" type="text/javascript"></script>
<script src="../js/jquery.min.js"></script>
<script src="../js/bootstrap.bundle.min.js"></script>
<script src="../js/slick.min.js"></script>
<script src="../js/custom.js"></script>
<script>
    $().ready(function() {
        $(".gallery-slider").slick({
            arrows: true,
            infinite: false,
            dots: false,
            slidesToShow: 1,
            autoplay: true,
            prevArrow: '<button class="slide-arrow prev-arrow"><i class="fa-solid fa-arrow-left"></i></button>',
            nextArrow: '<button class="slide-arrow next-arrow"><i class="fa-solid fa-arrow-right"></i></button>',
            responsive: [{
                breakpoint: 575,
                settings: {
                    infinite: true,
                    arrows: false,
                    dots: true,
                },
            }, ],
        });
        $(".product-slider").slick({
            arrows: false,
            infinite: true,
            dots: false,
            slidesToShow: 2,
            slidesToScroll: 1,
            autoplay: true,
            responsive: [{
                breakpoint: 575,
                settings: {
                    slidesToShow: 1,
                },
            }, ],
        });
        $(".testimonial-slider").slick({
            arrows: false,
            infinite: true,
            dots: false,
            slidesToShow: 1,
            autoplay: true,
        });
        $(document).ready(function() {
            $(".center-slider").slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                centerMode: true,
                arrows: false,
                dots: true,
                speed: 300,
                centerPadding: "130px",
                autoplay: false,
                responsive: [{
                        breakpoint: 768,
                        settings: {
                            centerPadding: "100px",
                        },
                    },
                    {
                        breakpoint: 575,
                        settings: {
                            centerPadding: "0",
                        },
                    },
                ],
            });
        });
    });
</script>
<script>
    $("#myID").flatpickr();
</script>

<script>
    $(document).ready(function() {
        $('.dropdown1').hover(function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeIn(100);
        }, function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeOut(100);
        });
    });
</script>

</html>
