<?php
$dataFile = 'data.json';
$data = json_decode(file_get_contents($dataFile), true);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <title>Home</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.4.1/css/bootstrap.min.css'>
</head>
<body>
    <div class="container py-4">
        <h1>Home</h1>

        <!-- Exibindo Categorias -->
        <h2>Categorias</h2>
        <ul>
            <?php foreach ($data['categories'] as $category) : ?>
                <li><?= htmlspecialchars($category) ?></li>
            <?php endforeach; ?>
        </ul>

        <!-- Exibindo Cards -->
        <h2>Cards</h2>
        <div class="row">
            <?php foreach ($data['cards'] as $item) : ?>
                <div class="col-md-4">
                    <div class="card mb-4">
                        <img src="<?= htmlspecialchars($item['imge']) ?>" class="card-img-top" alt="Imagem">
                        <div class="card-body">
                            <h5 class="card-title"><?= htmlspecialchars($item['name']) ?></h5>
                            <p class="card-text"><?= htmlspecialchars($item['desc']) ?></p>
                            <a href="<?= htmlspecialchars($item['url']) ?>" class="btn btn-primary">Saber Mais</a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
</body>
</html>