<?php
ini_set('display_errors',0);
ini_set('display_startup_errors',0);

session_start();

// Verifica se o usuário não está autenticado; se não estiver, redireciona para o login
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Função para carregar a lista de botões e categorias
function loadButtons() {
    $data = [
        'buttons' => [],
        'categories' => []
    ];

    if (file_exists('buttons.json')) {
        $data = json_decode(file_get_contents('buttons.json'), true);
    }

    return $data;
}

// Função para carregar as categorias existentes
function loadCategories() {
    $data = loadButtons();
    return $data['categories'];
}



// Verifica se o formulário de criação de botões foi submetido
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['create_button'])) {
    // Obtém os dados do formulário
    $button_name = $_POST['button_name'];
    $button_url = $_POST['button_url'];
    $button_category = $_POST['button_category'];

    // Carrega os botões existentes
    $data = loadButtons();
    $buttons = $data['buttons'];

    // Adiciona o novo botão
    $buttons[] = [
        'name' => $button_name,
        'url' => $button_url,
        'category' => $button_category
    ];

    // Atualiza a lista de botões no arquivo JSON
    $data['buttons'] = $buttons;
    file_put_contents('buttons.json', json_encode($data, JSON_PRETTY_PRINT));

    // Redireciona de volta para a página de configurações
    header("Location: settings.php");
    exit;
}





// Verifica se o formulário de criação de categorias foi submetido
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['create_category'])) {
    $category_name = $_POST['category_name'];
    $data = loadButtons();
    $categories = $data['categories'];

    // Adiciona a nova categoria
    $categories[] = $category_name;

    // Atualiza a lista de categorias no arquivo JSON
    $data['categories'] = $categories;
    file_put_contents('buttons.json', json_encode($data, JSON_PRETTY_PRINT));

    // Redireciona de volta para a página de configurações
    header("Location: settings.php");
    exit;
}




// Verifica se o formulário de remoção de botões foi submetido
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['remove_button'])) {
    $remove_index = $_POST['remove_index'];

    // Carrega os botões existentes
    $data = loadButtons();
    $buttons = $data['buttons'];

    // Remove o botão especificado pelo índice
    if (isset($buttons[$remove_index])) {
        unset($buttons[$remove_index]);
        $buttons = array_values($buttons); // Reindexa o array
    }

    // Atualiza a lista de botões no arquivo JSON
    $data['buttons'] = $buttons;
    file_put_contents('buttons.json', json_encode($data, JSON_PRETTY_PRINT));

    // Redireciona de volta para a página de configurações
    header("Location: settings.php");
    exit;
}




// Carrega os botões e categorias existentes
$data = loadButtons();
$buttons = $data['buttons'];
$categories = $data['categories'];
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #007bff;
        }

        form {
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }

        input[type="text"], select {
            width: 100%;
            padding: 10px;
            font-size: 1rem;
            border: 1px solid #ddd;
            border-radius: 5px;
            transition: border-color 0.3s;
        }

        input[type="text"]:focus, select:focus {
            border-color: #007bff;
            outline: none;
        }

        button {
            width: 100%;
            padding: 10px;
            font-size: 1rem;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        button:hover {
            background-color: #0056b3;
        }

        .category-list, .button-list {
            margin-top: 20px;
        }

        .category-list h3, .button-list h3 {
            margin-bottom: 10px;
            color: #007bff;
        }

        .category-list ul, .button-list ul {
            list-style: none;
            padding: 0;
        }

        .category-list li, .button-list li {
            padding: 10px;
            background-color: #f9f9f9;
            margin-bottom: 10px;
            border-radius: 5px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .button-list li {
            flex-wrap: wrap;
        }

        .button-list a {
            color: #007bff;
            text-decoration: none;
            margin-right: 10px;
            word-break: break-all;
        }

        .button-list form {
            display: inline;
        }

        .button-list button {
            background-color: #dc3545;
            width: auto;
            padding: 5px 10px;
            font-size: 0.875rem;
            margin-left: 10px;
        }

        .footer {
            text-align: center;
            margin-top: 20px;
        }

        .footer a {
            background-color: #007bff;
            color: #fff;
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            margin: 0 10px;
            transition: background-color 0.3s;
        }

        .footer a:hover {
            background-color: #0056b3;
        }

    </style>
</head>
<body>
    <div class="container">
        <h2>Configurações</h2>

        <!-- Formulário para criar novas categorias -->
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <div class="form-group">
                <label for="category_name">Nome da Categoria:</label>
                <input type="text" id="category_name" name="category_name" required>
            </div>
            <button type="submit" name="create_category">Criar Categoria</button>
        </form>

        <!-- Formulário para adicionar novos botões -->
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <div class="form-group">
                <label for="button_name">Nome do Botão:</label>
                <input type="text" id="button_name" name="button_name" required>
            </div>
            <div class="form-group">
                <label for="button_url">URL do Botão:</label>
                <input type="text" id="button_url" name="button_url" required>
            </div>
            <div class="form-group">
                <label for="button_category">Categoria do Botão:</label>
                <select id="button_category" name="button_category" required>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?php echo htmlspecialchars($category); ?>"><?php echo htmlspecialchars($category); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button type="submit" name="create_button">Criar Botão</button>
        </form>

        <!-- Listagem de categorias existentes -->
        <?php if (!empty($categories)): ?>
            <div class="category-list">
                <h3>Categorias</h3>
                <ul>
                    <?php foreach ($categories as $category): ?>
                        <li><?php echo htmlspecialchars($category); ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

        <!-- Listagem de botões existentes -->
        <?php if (!empty($buttons)): ?>
            <div class="button-list">
                <h3>Botões</h3>
                <ul>
                    <?php foreach ($buttons as $index => $button): ?>
                        <li>
                            <span>
                                <strong><?php echo htmlspecialchars($button['name']); ?></strong> - 
                                <a href="<?php echo htmlspecialchars($button['url']); ?>" target="_blank"><?php echo htmlspecialchars($button['url']); ?></a>
                            </span>
                            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" style="display: inline;">
                                <input type="hidden" name="remove_index" value="<?php echo $index; ?>">
                                <button type="submit" name="remove_button">Remover</button>
                            </form>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

        <!-- Botão "Voltar à tela inicial" -->
        <div class="footer">
            <a href="index.php">Voltar à tela inicial</a><p>
            <form action="logout.php" method="post" style="display: inline;">
                <button type="submit" class="button">Sair</button>
            </form>
        </div>
    </div>
</body>
</html>
