<?php
session_start(); // Inicia a sessão PHP

// Carrega os botões e categorias existentes de settings.php
$data = json_decode(file_get_contents('buttons.json'), true);
$buttons = $data['buttons'] ?? [];
$categories = $data['categories'] ?? [];

// Obtém uma imagem aleatória da pasta uploads para o background
$uploadPath = 'uploads/';
$images = glob($uploadPath . '*.{jpg,jpeg,png,gif}', GLOB_BRACE);
$random_image = $images[array_rand($images)]; // Seleciona uma imagem aleatória
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Central Start 3D Mídia</title>
    
    <!-- Favicon -->
    <link rel="icon" href="favicon.png" type="image/png">

    <!-- Open Graph Metadata para WhatsApp -->
    <meta property="og:title" content="Central Start 3D Mídia">
    <meta property="og:description" content="Bem-vindo ao Central Start 3D Mídia. Clique para ver mais!">
    <meta property="og:image" content="https://master.s3dmidia.com.br/logo.png?v=1"> <!-- URL completa da logomarca com parâmetro de versão -->
    <meta property="og:url" content="https://master.s3dmidia.com.br"> <!-- URL do seu site -->
    <meta property="og:type" content="website">
    <meta property="og:image:width" content="1200"> <!-- Largura da imagem -->
    <meta property="og:image:height" content="630"> <!-- Altura da imagem -->

    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            padding: 20px;
            background-image: url('<?php echo $random_image; ?>');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
        }
        .login-container {
            background-color: rgba(0, 0, 0, 0.7); /* Fundo preto com transparência */
            padding: 20px;
            border-radius: 10px;
            max-width: 400px;
            margin: auto;
            margin-top: 50px;
        }
        .login-container h2 {
            color: #fff;
            font-size: 24px;
            margin-bottom: 20px;
        }
        .login-container input[type="email"],
        .login-container input[type="password"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
        }
        .login-container button {
            width: 100%;
            padding: 10px;
            background: linear-gradient(to right, #ff7e5f, #feb47b); /* Gradiente de cor */
            border: none;
            border-radius: 5px;
            font-size: 18px;
            color: #fff;
            cursor: pointer;
        }
        .login-container button:hover {
            background: linear-gradient(to right, #feb47b, #ff7e5f); /* Gradiente invertido */
        }
        .login-container a {
            color: #fff;
            text-decoration: underline;
            font-size: 14px;
            display: block;
            margin-top: 10px;
        }
        .social-icons {
            margin-top: 20px;
        }
        .social-icons img {
            width: 30px;
            margin: 0 5px;
            vertical-align: middle;
        }
    </style>
</head>
<body>

    <div class="login-container">
        <h2>Faça seu login</h2>
        <form action="login.php" method="post">
            <input type="email" name="email" placeholder="Insira seu email" required>
            <input type="password" name="password" placeholder="Insira sua senha" required>
            <button type="submit">Entrar</button>
        </form>
        <a href="#">Esqueci minha senha</a>
        <a href="#">Ainda não tenho uma conta</a>
        <div class="social-icons">
            <a href="#"><img src="github-icon.png" alt="GitHub"></a>
            <a href="#"><img src="linkedin-icon.png" alt="LinkedIn"></a>
            <a href="#"><img src="instagram-icon.png" alt="Instagram"></a>
        </div>
    </div>

</body>
</html>