<?php
session_start(); // Inicia a sessão PHP

// Carrega os botões e categorias existentes de settings.php
$data = json_decode(file_get_contents('buttons.json'), true);
$buttons = $data['buttons'] ?? [];
$categories = $data['categories'] ?? [];

// Obtém uma imagem aleatória da pasta uploads para o background
$uploadPath = 'uploads/';
$images = glob($uploadPath . '*.{jpg,jpeg,png,gif}', GLOB_BRACE);
$random_image = $images[array_rand($images)]; // Seleciona uma imagem aleatória
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Central Start 3D Mídia</title>
    
    <!-- Favicon -->
    <link rel="icon" href="favicon.png" type="image/png">

    <!-- Open Graph Metadata para WhatsApp -->
    <meta property="og:title" content="Central Start 3D Mídia">
    <meta property="og:description" content="Bem-vindo ao Central Start 3D Mídia. Clique para ver mais!">
    <meta property="og:image" content="https://master.s3dmidia.com.br/logo.png?v=1"> <!-- URL completa da logomarca com parâmetro de versão -->
    <meta property="og:url" content="https://master.s3dmidia.com.br"> <!-- URL do seu site -->
    <meta property="og:type" content="website">
    <meta property="og:image:width" content="1200"> <!-- Largura da imagem -->
    <meta property="og:image:height" content="630"> <!-- Altura da imagem -->

    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            padding: 20px;
            background-image: url('<?php echo $random_image; ?>');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
        }
        .logo {
            max-width: 225px; /* Reduz o tamanho da logo em 50% */
            margin: 0 auto 20px; /* Centraliza e adiciona margem inferior */
            display: block; /* Para centralizar com margin: 0 auto; */
        }
        .section-title {
            margin-bottom: 10px;
            font-size: 36px;
            font-weight: bold;
            color: #fff;
            text-shadow: 3px 3px 10px rgba(0, 0, 0, 0.8); /* Sombra mais escura */
        }
        .category-container {
            background-color: rgba(0, 0, 0, 0.4); /* Fundo preto com 60% de transparência */
            padding: 10px;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.5);
            margin-top: 20px;
            text-align: center; /* Título no meio */
            max-width: 80%; /* Largura máxima do container */
            margin: 0 auto 20px; /* Centralizar container e adicionar margem inferior */
        }
        .category-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #fff;
            text-shadow: 2px 2px 6px rgba(0, 0, 0, 0.8); /* Sombra mais escura */
        }
        .button-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 10px; /* Espaçamento entre botões */
            margin-top: 20px;
        }
        .button {
            display: inline-block;
            padding: 12px 24px; /* Aumenta o espaçamento interno */
            font-size: 16px;
            background-color: #007bff;
            color: #fff;
            text-decoration: none;
            border-radius: 8px; /* Cantos mais arredondados */
            transition: background-color 0.3s;
            width: calc(25% - 20px); /* Calcula o tamanho para 4 botões por linha */
            max-width: 200px; /* Máxima largura dos botões */
            text-align: center; /* Centraliza o texto */
        }
        .button:hover {
            background-color: #0056b3;
        }
        .footer-button {
            margin-top: 50px;
        }
        .footer-button .button {
            background-color: #dc3545; /* Vermelho */
        }
    </style>
</head>
<body>

    <!-- Logomarca -->
    <img src="logo.png" alt="Logomarca" class="logo">

    <!-- Título -->
    <div class="section-title">
        Central<br>Start 3D Mídia
    </div>

    <!-- Botões organizados por categorias -->
    <?php foreach ($categories as $category): ?>
    <div class="category-container">
        <h3 class="category-title"><?php echo $category; ?></h3>
        <div class="button-container">
            <?php $count = 0; ?>
            <?php foreach ($buttons as $button): ?>
                <?php if ($button['category'] === $category): ?>
                    <a href="<?php echo $button['url']; ?>" class="button"><?php echo $button['name']; ?></a>
                    <?php $count++; ?>
                    <?php if ($count % 4 === 0): ?>
                        <br>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endforeach; ?>

    <!-- Botão de Configurações no Rodapé -->
    <div class="footer-button">
        <a href="settings.php">
            <button class="button">Configurações</button>
        </a>
    </div>

</body>
</html>