<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Área de clientes</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8f9fa;
        }
        
        #content {
            margin-left: 250px;
            padding: 20px;
            transition: margin-left 0.3s ease;
        }
        
        .message-container {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            border-radius: 4px;
            padding: 15px;
            margin-bottom: 20px;
            color: #155724;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .message-containerErro {
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 4px;
            padding: 15px;
            margin-bottom: 20px;
            color: #721c24;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .search-bar {
            margin-bottom: 15px;
        }

        .user-card {
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        .user-card:hover {
            transform: translateY(-5px);
        }
        
        .card-body {
            padding: 20px;
        }
        .card-title {
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }
        .btn-outline-success {
            border-color: #28a745;
            color: #28a745;
        }
        .btn-outline-success:hover {
            background-color: #28a745;
            color: #fff;
        }
        .modal-header h2 {
            font-size: 1.5rem;
        }
        .modal-content {
            border-radius: 20px;
        }
        .modal-footer .btn {
            border-radius: 4px;
        }

        /* Responsividade */
        
    </style>
</head>
<body>

<!-- Modal de confirmação de exclusão -->
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2>ATENÇÃO</h2>
            </div>
            <div class="modal-body">
                Tem certeza de que deseja excluir este usuário?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">CANCELAR</button>
                <a class="btn btn-danger btn-ok" href="#">SIM</a>
            </div>
        </div>
    </div>
</div>

<!-- Modal de confirmação de renovação -->
<div class="modal fade" id="confirm-renewal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2>CONFIRMAÇÃO DE RENOVAÇÃO</h2>
            </div>
            <div class="modal-body">
                Tem certeza de que deseja renovar a assinatura deste usuário por mais 1 mês?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">CANCELAR</button>
                <a class="btn btn-warning btn-renew" href="#">SIM</a>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <?php include 'laterais.php'; ?>

        <!-- Conteúdo -->
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-md-4" id="content">
            <center><h1 class="mt-2">Usuários</h1></center>

            <div class="search-bar">
                <input type="text" id="searchInput" class="form-control" placeholder="Pesquisar usuário..." onkeyup="searchUser()">
            </div>

            <p>
                <?php
                
                if (isset($_GET["option"]) && $_GET["option"] == "apagar") {
                    $id = $_GET['id'];

                    if (!empty($id) && is_numeric($id)) {

                        $db_check = new SQLite3('.listausuarios.db');

                        $db_check->exec('CREATE TABLE IF NOT EXISTS USERS(
                          id INTEGER PRIMARY KEY AUTOINCREMENT,
                          nome TEXT,
                          descricao TEXT, 
                          whatsapp TEXT, 
                          datavencimento TEXT, 
                          datainicio TEXT, 
                          servidor TEXT, 
                          conexao TEXT, 
                          nomedoapk TEXT, 
                          macdoapk TEXT, 
                          chavedoapk TEXT, 
                          tipodedispositivo TEXT, 
                          indicacao TEXT
                        )');

                        $stmt = $db_check->prepare('DELETE FROM USERS WHERE id = :id');
                        $stmt->bindValue(':id', $id, SQLITE3_INTEGER);

                        if ($stmt->execute()) {
                            echo "<script>alert('Usuário deletado com sucesso.');</script>";
                            echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
                        } else {
                            echo "<script>alert('Erro ao deletar o usuário.');</script>";
                            echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
                        }
                    } else {
                        echo "<script>alert('Usuário inválido.');</script>";
                        echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
                    }
                }

                if ($_GET["option"] == "iniciar") {
                    $nomeUsuario = $_GET["nome"];
                    $nomeUsuarioGET = $_GET['apagar'];
                    $nomeUsuarioGETConfirmado = $_GET['apagarconfirmado'];

                    if ($nomeUsuarioGET == "" && $nomeUsuarioGETConfirmado == "") {
                        $db_check = new SQLite3('.listausuarios.db');
                        $db_check->exec('CREATE TABLE IF NOT EXISTS USERS(
                            id INTEGER PRIMARY KEY AUTOINCREMENT,
                            nome TEXT,
                            descricao TEXT, 
                            whatsapp TEXT, 
                            datavencimento TEXT, 
                            datainicio TEXT, 
                            servidor TEXT, 
                            conexao TEXT, 
                            nomedoapk TEXT, 
                            macdoapk TEXT, 
                            chavedoapk TEXT, 
                            tipodedispositivo TEXT, 
                            indicacao TEXT
                        )');

                        $result = $db_check->querySingle('SELECT COUNT(*) AS total FROM USERS');
                        echo "<center><div class=\"message-container\">Total de clientes cadastrados: " . $result . "</div></center>";

                        $sql_listar = ($nomeUsuario == "") ? "SELECT * FROM USERS" : "SELECT * FROM USERS WHERE macdoapk LIKE '%$nomeUsuario%'";
                        $resultado = $db_check->query($sql_listar);

                        if ($resultado) {
                            echo '<div class="row">';
                            while ($row = $resultado->fetchArray(SQLITE3_ASSOC)) {
                                $datavencimento = $row['datavencimento'];
                                $datainicio = $row['datainicio'];
                                
                                $servidor = $row['servidor'];
                                
                                $dataAtual = date('Y-m-d');
                                
                                $diferenca = strtotime($row['datavencimento']) - strtotime($dataAtual);
                                $diasFaltando = ceil($diferenca / (60 * 60 * 24));

                                $diasFaltandoInt = $diasFaltando;
                                
                                if ($diasFaltando <= 0) {
                                    $diasFaltando = " - <span class=\"text-danger\">Vencido</span>";
                                } else {
                                    $diasFaltando = " - <span class=\"text-primary\">Vence em $diasFaltando dias</span>";
                                }

                                $data_datainicio = new DateTime($datainicio);
                                $dataFormatada_datainicio = $data_datainicio->format('d/m/Y');
                                
                                $data_datavencimento = new DateTime($datavencimento);
                                $dataFormatada_datavencimento = $data_datavencimento->format('d/m/Y');  
                                                         
                                $apenasNumeros = $row['whatsapp'];

                                $mensagem = $dataAtual = new DateTime(); // Data atual
$dataVencimento = new DateTime($row['datavencimento']); // Data de vencimento do usuário

// Verifica o status do cadastro
if ($dataVencimento < $dataAtual) {
    $status = "expirou em *_" . $dataFormatada_datavencimento . "_*";
    $mensagem = "Olá, *_".$row['nome']."_* ! 
Seu acesso ao serviço *_".$servidor."_* *_" . $status . "_*. 
Para continuar desfrutando de nossos serviços, entre em contato para renovar seu acesso.

Para ter acesso aos dados de pagamento *_DIGITE PIX_* aqui no chat";
} elseif ($dataVencimento->format('Y-m-d') === $dataAtual->format('Y-m-d')) {
    $status = "expira hoje";
    $mensagem = "Olá, *_".$row['nome']."_* ! 
Seu acesso ao serviço *_".$servidor."_* " . $status . ". 
Para continuar desfrutando de nossos serviços, entre em contato para renovar seu acesso.

Para ter acesso aos dados de pagamento *_DIGITE PIX_* aqui no chat";
} elseif ($dataVencimento <= (clone $dataAtual)->modify('+7 days')) {
    $diasFaltando = $dataVencimento->diff($dataAtual)->days;
    $status = "está prestes a expirar em menos de " . $diasFaltando . " dias";
    $mensagem = "Olá, *_".$row['nome']."_* ! 
Seu acesso ao serviço *_".$servidor."_* " . $status . ". 
Para continuar desfrutando de nossos serviços, entre em contato para renovar seu acesso.

Para ter acesso aos dados de pagamento *_DIGITE PIX_* aqui no chat";
} else {
    $diasFaltando = $dataVencimento->diff($dataAtual)->days;
    $status = "está ativo e faltam " . $diasFaltando . " dias para vencer";
    $mensagem = "Olá, *_".$row['nome']."_* ! 
Seu acesso ao serviço *_".$servidor."_* " . $status . ". 
Para continuar desfrutando de nossos serviços, entre em contato para renovar seu acesso.

Para ter acesso aos dados de pagamento *_DIGITE PIX_* aqui no chat";
}

                                $mensagem2 = "Opa, *_".$row['nome']."_* Obrigado ☺️

É com *_grande satisfação_* que confirmamos o recebimento do seu pagamento referente à mensalidade do seu plano.
Informamos que seu serviço estará *_renovado em até 5 minutos._*
Agradecemos pela confiança em nossos serviços e esperamos continuar atendendo às suas expectativas.
                                ";

                                $urlWhatsapp = "https://api.whatsapp.com/send?phone=" . urlencode($apenasNumeros) . "&text=" . urlencode($mensagem);
                                $urlWhatsapp2 = "https://api.whatsapp.com/send?phone=" . urlencode($apenasNumeros) . "&text=" . urlencode($mensagem2);

                                echo "
                                <div class=\"col-md-4 mb-4\">
                                    <div class=\"card user-card\">
                                        <div class=\"card-body\">
                                            <h5 class=\"card-title\"><strong>🧑 </strong> <span class=\"text-primary\">" . htmlspecialchars($row['nome']) . "</span></h5>
                                            <p class=\"card-text\">
                                                <strong>🗓️ Data de Início:</strong> <span class=\"text-primary\">" . htmlspecialchars($dataFormatada_datainicio) . "</span><br>
                                        
                                                <strong>🌐 Servidor:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['servidor']) . "</span><br>
                                                
                                                <strong>🔢 Conexão:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['conexao']) . "</span><br>
                                                
                                                <strong>🤖 Nome do APK:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['nomedoapk']) . "</span><br>
                                                
                                                <strong>🔗 Endereço MAC:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['macdoapk']) . "</span><br>
                                                
                                                <strong>🔑 Chave do APK:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['chavedoapk']) . "</span><br>
                                                
                                                <strong>🖥️ Tipo de Dispositivo:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['tipodedispositivo']) . "</span><br>
                                                
                                                <strong>🖥️ Informações:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['indicacao']) . "</span><br>
                                                
                                                 <strong>💰 Valor Pago:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['descricao']) . "</span><br>     
                                                
                                                <strong>📆 Vencimento:</strong> <span class=\"text-danger\">" . htmlspecialchars($dataFormatada_datavencimento) . " <strong>Falta:</strong>" .  $diasFaltando . "
                                            </p>
                                            <p>
                                                <strong>Mensagem Cobrança</strong> 
                                                <a href=\"$urlWhatsapp\" target=\"_blank\" class=\"btn btn-outline-success\">
                                                    📤 Whatsapp
                                                </a>
                                            </p>
                                            <p>
                                                <strong>Mensagem Confirmação</strong> 
                                                <a href=\"$urlWhatsapp2\" target=\"_blank\" class=\"btn btn-outline-success\">
                                                    📤 Whatsapp
                                                </a>
                                            </p>
                                            
                                             <!-- Botão de Renovação de 1 mês -->
                                       <center><form action=\"#\" method=\"post\" class=\"d-inline\">
                                            <input type=\"hidden\" name=\"id\" value=\"" . htmlspecialchars($row['id']) . "\" required>
                                            <button type=\"button\" class=\"btn btn-warning\" data-bs-toggle=\"modal\" data-bs-target=\"#confirm-renewal\" data-href=\"renovar.php?id=" . htmlspecialchars($row['id']) . "\">♻️ Renovar 1 Mês</button>
                                        </form>
                                            </p>
                                            <center><form action=\"editar.php\" method=\"get\" class=\"d-inline\">
                                                <input type=\"hidden\" name=\"option\" value=\"editar\">
                                                <input type=\"hidden\" name=\"id\" value=\"" . htmlspecialchars($row['id']) . "\" required>
                                                <center><button type=\"submit\" class=\"btn btn-primary\">✍🏻 Editar Usuario</button>
                                            </form>
                                            
                                            <center><form action=\"listausuarios.php\" method=\"get\" class=\"d-inline\">
                                                <input type=\"hidden\" name=\"option\" value=\"apagar\">
                                                <input type=\"hidden\" name=\"id\" value=\"" . htmlspecialchars($row['id']) . "\" required>
                                               <button type=\"button\" class=\"btn btn-danger\" data-bs-toggle=\"modal\" data-bs-target=\"#confirm-delete\" data-href=\"listausuarios.php?option=apagar&id=" . htmlspecialchars($row['id']) . "\">🗑️ Excluir</button></center>
                                            </form>
                       
                                        
                                    </div>
                                </div>
                            </div>
                            ";
                            }
                            echo '</div>'; // Fecha a div.row
                        } else {
                            echo "<div class=\"message-containerErro\">Erro na consulta: " . $db_check->lastErrorMsg() . "</div>";
                        }
                    }
                }
                ?>
            </p>
        </main>
    </div>
</div>

<!-- jQuery (necessário para o modal funcionar) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Bootstrap JS e dependências -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>

<script>
    function searchUser() {
        var input, filter, cards, cardContainer, i, txtValue;
        input = document.getElementById("searchInput");
        filter = input.value.toUpperCase();
        cardContainer = document.getElementById("content");
        cards = cardContainer.getElementsByClassName("user-card");
        for (i = 0; i < cards.length; i++) {
            txtValue = cards[i].textContent || cards[i].innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                cards[i].style.display = "";
            } else {
                cards[i].style.display = "none";
            }
        }
    }
    
    $('#confirm-delete').on('show.bs.modal', function (e) {
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
    });
    
    $('#confirm-renewal').on('show.bs.modal', function (e) {
        $(this).find('.btn-renew').attr('href', $(e.relatedTarget).data('href'));
    });
</script>

</body>
</html>
