<?php
session_start(); // Inicia a sessão PHP

// Verifica se o usuário não está autenticado; se não estiver, redireciona para o login
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Carrega os botões e categorias existentes de settings.php
$data = json_decode(file_get_contents('buttons.json'), true);
$buttons = $data['buttons'] ?? [];
$categories = $data['categories'] ?? [];

// Obtém uma imagem aleatória da pasta uploads para o background
$uploadPath = 'uploads/';
$images = glob($uploadPath . '*.{jpg,jpeg,png,gif}', GLOB_BRACE);
$random_image = $images[array_rand($images)]; // Seleciona uma imagem aleatória
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Central De Links TVon</title>
    
    <!-- Favicon -->
    <link rel="icon" href="favicon.png" type="image/png">

    <!-- Open Graph Metadata para WhatsApp e outras redes sociais -->
    <meta property="og:title" content="Central De Links TVon">
    <meta property="og:description" content="Bem-vindo ao Central De Links TVon. Clique para ver mais!">
    <meta property="og:image" content="https://i.postimg.cc/6QJDP760/GRUPO_ON_Sem_Fundo_sem_nome_PNG.png"> <!-- URL completa da imagem -->
    <meta property="og:url" content="https://"> <!-- URL do seu site -->
    <meta property="og:type" content="website">
    <meta property="og:image:width" content="1200"> <!-- Largura da imagem -->
    <meta property="og:image:height" content="630"> <!-- Altura da imagem -->

    <!-- Twitter Card Metadata -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Central De Links TVon">
    <meta name="twitter:description" content="Bem-vindo ao Central De Links TVon. Clique para ver mais!">
    <meta name="twitter:image" content="/uploads/logo.png">

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            text-align: center;
            margin: 0;
            background-image: url('<?php echo $random_image; ?>');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            color: #fff;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .container {
            padding: 20px;
            background-color: rgba(0, 0, 0, 0.4); /* Fundo preto com transparência */
            margin: 40px auto;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.4);
            max-width: 1200px;
            width: 90%;
            flex: 1;
        }

        .logo {
            max-width: 150px;
            margin: 0 auto 20px;
        }

        .section-title {
            font-size: 36px;
            font-weight: bold;
            margin-bottom: 20px;
            text-shadow: 3px 3px 10px rgba(0, 0, 0, 0.8);
        }

        .category-container {
            background-color: rgba(255, 255, 255, 0.1); /* Fundo branco com transparência */
            padding: 20px;
            border-radius: 10px;
            margin-top: 20px;
        }

        .category-title {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 10px;
            text-shadow: 2px 2px 6px rgba(0, 0, 0, 0.8);
        }

        .button-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
        }

        .button {
            padding: 15px 30px;
            font-size: 16px;
            background-color: #007bff;
            color: #fff;
            text-decoration: none;
            border-radius: 10px;
            transition: background-color 0.3s, transform 0.3s;
            text-align: center;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .button:hover {
            background-color: #0056b3;
            transform: translateY(-5px);
        }

        .footer-button {
            margin-top: 40px;
        }

        .footer-button .button {
            background-color: #dc3545;
        }

    </style>
</head>
<body>

    <div class="container">
        <!-- Logomarca -->
       

        <!-- Título -->
        <div class="section-title">
            <center>Central <br>Links e Mídias</center>
        </div>

        <!-- Botões organizados por categorias -->
        <?php foreach ($categories as $category): ?>
        <div class="category-container">
            <h3 class="category-title"><?php echo $category; ?></h3>
            <div class="button-container">
                <?php foreach ($buttons as $button): ?>
                    <?php if ($button['category'] === $category): ?>
                        <a href="<?php echo $button['url']; ?>" class="button"><?php echo $button['name']; ?></a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>

        <!-- Botão de Configurações no Rodapé -->
        <div class="footer-button">
            <a href="settings.php">
                <button class="button">Painel de Configurações</button>
            </a>
        </div>

    </div>

</body>
</html>
