<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Carrega a lista de botões e categorias
function loadButtons() {
    $data = [
        'buttons' => [],
        'categories' => []
    ];

    if (file_exists('buttons.json')) {
        $data = json_decode(file_get_contents('buttons.json'), true);
    }

    return $data;
}

// Obtém o índice do botão a ser editado
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['edit_index'])) {
    $edit_index = $_GET['edit_index'];

    // Carrega os botões existentes
    $data = loadButtons();
    $buttons = $data['buttons'];

    // Verifica se o índice é válido
    if (isset($buttons[$edit_index])) {
        $button_to_edit = $buttons[$edit_index];
    } else {
        header('Location: settings.php');
        exit;
    }
} elseif ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_button'])) {
    $edit_index = $_POST['edit_index'];
    $new_button_name = $_POST['button_name'];
    $new_button_url = $_POST['button_url'];

    // Carrega os botões existentes
    $data = loadButtons();
    $buttons = $data['buttons'];

    // Atualiza o botão
    if (isset($buttons[$edit_index])) {
        $buttons[$edit_index]['name'] = $new_button_name;
        $buttons[$edit_index]['url'] = $new_button_url;
        $data['buttons'] = $buttons;
        file_put_contents('buttons.json', json_encode($data, JSON_PRETTY_PRINT));
    }

    header('Location: settings.php');
    exit;
} elseif ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['delete_button'])) {
    $edit_index = $_POST['edit_index'];

    // Carrega os botões existentes
    $data = loadButtons();
    $buttons = $data['buttons'];

    // Remove o botão
    if (isset($buttons[$edit_index])) {
        unset($buttons[$edit_index]);
        $buttons = array_values($buttons);
        $data['buttons'] = $buttons;
        file_put_contents('buttons.json', json_encode($data, JSON_PRETTY_PRINT));
    }

    header('Location: settings.php');
    exit;
} else {
    header('Location: settings.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Botão</title>
    <style>
        /* Estilos do formulário */
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #007bff;
        }
        form {
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            font-size: 1rem;
            border: 1px solid #ddd;
            border-radius: 5px;
            transition: border-color 0.3s;
        }
        input[type="text"]:focus {
            border-color: #007bff;
            outline: none;
        }
        button {
            width: 100%;
            padding: 10px;
            font-size: 1rem;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Editar Botão</h2>

        <!-- Formulário para editar o botão -->
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <div class="form-group">
                <label for="button_name">Nome do Botão:</label>
                <input type="text" id="button_name" name="button_name" value="<?php echo htmlspecialchars($button_to_edit['name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="button_url">URL do Botão:</label>
                <input type="text" id="button_url" name="button_url" value="<?php echo htmlspecialchars($button_to_edit['url']); ?>" required>
            </div>
            <button type="submit" name="update_button">Atualizar Botão</button>
            <button type="submit" name="delete_button">Remover Botão</button>
            <input type="hidden" name="edit_index" value="<?php echo htmlspecialchars($edit_index); ?>">
        </form>

        <!-- Botão para voltar -->
        <div style="text-align: center;">
            <a href="settings.php">Voltar à Configurações</a>
        </div>
    </div>
</body>
</html>
